/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets.internal;

import java.text.NumberFormat;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.TableCell;
import org.netxms.client.TableRow;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.datacollection.Messages;

public class TableLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private static final Color FOREGROUND_COLOR_DARK = new Color((Device)Display.getCurrent(), 0, 0, 0);
    private static final Color FOREGROUND_COLOR_LIGHT = new Color((Device)Display.getCurrent(), 255, 255, 255);
    private static final Color[] FOREGROUND_COLORS;
    private boolean useMultipliers = false;

    static {
        Color[] colorArray = new Color[5];
        colorArray[1] = FOREGROUND_COLOR_DARK;
        colorArray[2] = FOREGROUND_COLOR_DARK;
        colorArray[3] = FOREGROUND_COLOR_LIGHT;
        colorArray[4] = FOREGROUND_COLOR_LIGHT;
        FOREGROUND_COLORS = colorArray;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        TableRow row = (TableRow)element;
        if (columnIndex >= row.size()) {
            return null;
        }
        return this.useMultipliers ? this.getValue(row.get(columnIndex).getValue()) : row.get(columnIndex).getValue();
    }

    private String getValue(String value) {
        try {
            long i = Long.parseLong(value);
            if (i >= 10000000000000L || i <= -10000000000000L) {
                return String.valueOf(Long.toString(i / 1000000000000L)) + " T";
            }
            if (i >= 10000000000L || i <= -10000000000L) {
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Long.toString(i / 1000000000L)));
                Messages.get();
                return stringBuilder.append(Messages.LastValuesLabelProvider_Giga).toString();
            }
            if (i >= 10000000L || i <= -10000000L) {
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Long.toString(i / 1000000L)));
                Messages.get();
                return stringBuilder.append(Messages.LastValuesLabelProvider_Mega).toString();
            }
            if (i >= 10000L || i <= -10000L) {
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Long.toString(i / 1000L)));
                Messages.get();
                return stringBuilder.append(Messages.LastValuesLabelProvider_Kilo).toString();
            }
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            double d = Double.parseDouble(value);
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMaximumFractionDigits(2);
            if (d >= 1.0E13 || d <= -1.0E13) {
                return String.valueOf(nf.format(d / 1.0E12)) + " T";
            }
            if (d >= 1.0E10 || d <= -1.0E10) {
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(nf.format(d / 1.0E9)));
                Messages.get();
                return stringBuilder.append(Messages.LastValuesLabelProvider_Giga).toString();
            }
            if (d >= 1.0E7 || d <= -1.0E7) {
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(nf.format(d / 1000000.0)));
                Messages.get();
                return stringBuilder.append(Messages.LastValuesLabelProvider_Mega).toString();
            }
            if (d >= 10000.0 || d <= -10000.0) {
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(nf.format(d / 1000.0)));
                Messages.get();
                return stringBuilder.append(Messages.LastValuesLabelProvider_Kilo).toString();
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return value;
    }

    public Color getForeground(Object element, int columnIndex) {
        TableRow row = (TableRow)element;
        if (columnIndex >= row.size()) {
            return null;
        }
        TableCell cell = row.get(columnIndex);
        return cell.getStatus() >= 0 && cell.getStatus() < FOREGROUND_COLORS.length ? FOREGROUND_COLORS[cell.getStatus()] : null;
    }

    public Color getBackground(Object element, int columnIndex) {
        TableRow row = (TableRow)element;
        if (columnIndex >= row.size()) {
            return null;
        }
        TableCell cell = row.get(columnIndex);
        return cell.getStatus() > 0 ? StatusDisplayInfo.getStatusColor((int)cell.getStatus()) : null;
    }

    public void setUseMultipliers(boolean useMultipliers) {
        this.useMultipliers = useMultipliers;
    }
}

