/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Zone;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ZoneSelectionDialog
extends Dialog {
    private ObjectSelector objectSelector;
    private long zoneId;

    public ZoneSelectionDialog(Shell parent) {
        super(parent);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.ZoneSelectionDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.objectSelector = new ObjectSelector(dialogArea, 0, false);
        Messages.get();
        this.objectSelector.setLabel(Messages.ZoneSelectionDialog_ZoneObject);
        this.objectSelector.setObjectClass(Zone.class);
        this.objectSelector.setClassFilter(ObjectSelectionDialog.createZoneSelectionFilter());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.objectSelector.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        long objectId = this.objectSelector.getObjectId();
        if (objectId == 0L) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.ZoneSelectionDialog_Warning, (String)Messages.ZoneSelectionDialog_EmptySelectionWarning);
            return;
        }
        AbstractObject object = ((NXCSession)ConsoleSharedData.getSession()).findObjectById(objectId);
        if (object == null || !(object instanceof Zone)) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.ZoneSelectionDialog_Warning, (String)Messages.ZoneSelectionDialog_EmptySelectionWarning);
            return;
        }
        this.zoneId = ((Zone)object).getZoneId();
        super.okPressed();
    }

    public long getZoneId() {
        return this.zoneId;
    }
}

