/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.widgets.helpers.DashboardElementButton;

public abstract class CGroup
extends Canvas {
    private static final int BORDER_WIDTH = 3;
    private static final int HEADER_HEIGHT = 22;
    private String text;
    private Composite headerArea;
    private Control clientArea;
    private Color borderColor;
    private Color titleColor;
    private Action doubleClickAction = null;
    private List<DashboardElementButton> buttons = new ArrayList<DashboardElementButton>(0);

    public CGroup(Composite parent, String text) {
        super(parent, 0);
        this.text = text;
        this.borderColor = SharedColors.getColor("CGroup.Border", this.getDisplay());
        this.titleColor = SharedColors.getColor("CGroup.Title", this.getDisplay());
        this.headerArea = new Composite((Composite)this, 0);
        this.headerArea.setBackground(this.borderColor);
        RowLayout headerLayout = new RowLayout(256);
        headerLayout.marginBottom = 0;
        headerLayout.marginTop = 0;
        this.headerArea.setLayout((Layout)headerLayout);
        this.clientArea = this.createClientAreaInternal();
        this.setFont(JFaceResources.getBannerFont());
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                CGroup.this.doPaint(e.gc);
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (CGroup.this.doubleClickAction != null) {
                    CGroup.this.doubleClickAction.run();
                }
            }
        });
        GridLayout layout = new GridLayout();
        layout.marginWidth = 3;
        layout.marginHeight = 3;
        layout.verticalSpacing = 3;
        this.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.verticalAlignment = 4;
        gd.heightHint = 22 - layout.verticalSpacing;
        this.headerArea.setLayoutData((Object)gd);
    }

    private Control createClientAreaInternal() {
        Control ca = this.createClientArea((Composite)this);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        ca.setLayoutData((Object)gd);
        return ca;
    }

    private void doPaint(GC gc) {
        gc.setForeground(this.borderColor);
        gc.setLineWidth(3);
        Rectangle rect = this.getClientArea();
        ++rect.x;
        ++rect.y;
        rect.width -= 3;
        rect.height -= 3;
        gc.drawRectangle(rect);
        rect.height = 23;
        gc.setBackground(this.borderColor);
        gc.fillRectangle(rect);
        gc.setForeground(this.titleColor);
        gc.drawText(this.text, 5, 5);
    }

    protected abstract Control createClientArea(Composite var1);

    public boolean setFocus() {
        return this.clientArea.setFocus();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    protected Color getBorderColor() {
        return this.borderColor;
    }

    protected void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        this.headerArea.setBackground(borderColor);
        for (DashboardElementButton b : this.buttons) {
            b.getControl().setBackground(borderColor);
        }
    }

    protected Color getTitleColor() {
        return this.titleColor;
    }

    protected void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public void addButton(final DashboardElementButton button) {
        Label l = new Label(this.headerArea, 0);
        l.setBackground(this.getBorderColor());
        l.setImage(button.getImage());
        l.setToolTipText(button.getName());
        l.setCursor(this.getDisplay().getSystemCursor(21));
        l.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                button.getAction().run();
            }
        });
        button.setControl((Control)l);
        this.buttons.add(button);
    }

    public Action getDoubleClickAction() {
        return this.doubleClickAction;
    }

    public void setDoubleClickAction(Action doubleClickAction) {
        this.doubleClickAction = doubleClickAction;
    }

    public void replaceClientArea() {
        if (this.clientArea != null) {
            this.clientArea.dispose();
        }
        this.clientArea = this.createClientAreaInternal();
        this.layout();
    }
}

