/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import java.net.InetAddress;

public class InetAddressEx {
    public InetAddress address;
    public int mask;

    public InetAddressEx(InetAddress address, int mask) {
        this.address = address;
        this.mask = mask;
    }

    public InetAddressEx(InetAddress address, InetAddress mask) {
        this.address = address;
        this.mask = InetAddressEx.bitsInMask(mask);
    }

    public InetAddressEx(InetAddressEx src) {
        this.address = src.address;
        this.mask = src.mask;
    }

    public String toString() {
        return String.valueOf(this.address.getHostAddress().replaceFirst("(^|:)(0+(:|$)){2,8}", "::")) + "/" + this.mask;
    }

    public static int bitsInMask(InetAddress mask) {
        byte[] bytes;
        int bits = 0;
        byte[] byArray = bytes = mask.getAddress();
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b == 255) {
                bits += 8;
            } else {
                int m = 128;
                while (m != 0) {
                    if ((b & m) != m) break;
                    ++bits;
                    m >>= 1;
                }
            }
            ++n2;
        }
        return bits;
    }

    public InetAddress maskFromBits() {
        try {
            byte[] bytes = this.address.getAddress();
            int bits = this.mask;
            int i = 0;
            while (bits > 8) {
                bytes[i++] = -1;
                bits -= 8;
            }
            int b = -128;
            while (bits > 0) {
                int n = i;
                bytes[n] = (byte)(bytes[n] | b);
                b = (byte)(b >> 1);
                --bits;
            }
            return InetAddress.getByAddress(bytes);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

