/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.net.InetAddress;
import org.netxms.base.NXCPMessage;

public class IpAddressListElement {
    public static final int SUBNET = 0;
    public static final int RANGE = 1;
    private int type;
    private InetAddress addr1;
    private InetAddress addr2;

    public IpAddressListElement(int type, InetAddress addr1, InetAddress addr2) {
        this.type = type;
        this.addr1 = addr1;
        this.addr2 = addr2;
    }

    protected IpAddressListElement(NXCPMessage msg, long baseId) {
        this.type = msg.getFieldAsInt32(baseId);
        this.addr1 = msg.getFieldAsInetAddress(baseId + 1L);
        this.addr2 = msg.getFieldAsInetAddress(baseId + 2L);
    }

    public int getType() {
        return this.type;
    }

    public InetAddress getAddr1() {
        return this.addr1;
    }

    public InetAddress getAddr2() {
        return this.addr2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.addr1.getHostAddress());
        sb.append(this.type == 0 ? (char)'/' : '-');
        sb.append(this.addr2.getHostAddress());
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.addr1 == null ? 0 : this.addr1.hashCode());
        result = 31 * result + (this.addr2 == null ? 0 : this.addr2.hashCode());
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IpAddressListElement other = (IpAddressListElement)obj;
        if (this.addr1 == null ? other.addr1 != null : !this.addr1.equals(other.addr1)) {
            return false;
        }
        if (this.addr2 == null ? other.addr2 != null : !this.addr2.equals(other.addr2)) {
            return false;
        }
        return this.type == other.type;
    }
}

