/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objecttools;

import java.util.Set;
import java.util.regex.Pattern;
import org.netxms.base.Glob;
import org.netxms.base.Logger;
import org.netxms.base.NXCPMessage;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objecttools.ObjectToolFilter;

public class ObjectTool {
    public static final int TYPE_INTERNAL = 0;
    public static final int TYPE_ACTION = 1;
    public static final int TYPE_TABLE_SNMP = 2;
    public static final int TYPE_TABLE_AGENT = 3;
    public static final int TYPE_URL = 4;
    public static final int TYPE_LOCAL_COMMAND = 5;
    public static final int TYPE_SERVER_COMMAND = 6;
    public static final int TYPE_FILE_DOWNLOAD = 7;
    public static final int REQUIRES_SNMP = 1;
    public static final int REQUIRES_AGENT = 2;
    public static final int REQUIRES_OID_MATCH = 4;
    public static final int ASK_CONFIRMATION = 8;
    public static final int GENERATES_OUTPUT = 16;
    public static final int DISABLED = 32;
    public static final int SHOW_IN_COMMANDS = 64;
    public static final int REQUIRES_OS_MATCH = 128;
    public static final int REQUIRES_TEMPLATE_MATCH = 256;
    public static final int SNMP_INDEXED_BY_VALUE = 65536;
    protected long id;
    protected String name;
    protected String displayName;
    protected int type;
    protected int flags;
    protected String description;
    protected String data;
    protected String confirmationText;
    protected String commandName;
    protected String commandShortName;
    protected ObjectToolFilter filter;
    protected byte[] imageData;

    protected ObjectTool() {
        this.filter = new ObjectToolFilter();
    }

    public ObjectTool(NXCPMessage msg, long baseId) {
        block2: {
            this.id = msg.getFieldAsInt64(baseId);
            this.name = msg.getFieldAsString(baseId + 1L);
            this.type = msg.getFieldAsInt32(baseId + 2L);
            this.data = msg.getFieldAsString(baseId + 3L);
            this.flags = msg.getFieldAsInt32(baseId + 4L);
            String filterData = msg.getFieldAsString(baseId + 6L);
            this.description = msg.getFieldAsString(baseId + 5L);
            this.confirmationText = msg.getFieldAsString(baseId + 7L);
            this.commandName = msg.getFieldAsString(baseId + 8L);
            this.commandShortName = msg.getFieldAsString(baseId + 9L);
            this.imageData = msg.getFieldAsBinary(baseId + 10L);
            try {
                this.filter = ObjectToolFilter.createFromXml(filterData);
            }
            catch (Exception exception) {
                this.filter = new ObjectToolFilter();
                if (filterData.isEmpty()) break block2;
                Logger.debug("ObjectTool.ObjectTool", "Failed to create object tool filter from XML");
            }
        }
        this.createDisplayName();
    }

    protected void createDisplayName() {
        String[] parts = this.name.split("->");
        this.displayName = parts.length > 0 ? parts[parts.length - 1].replace("&", "").trim() : this.name.replace("&", "").trim();
    }

    public boolean isApplicableForNode(AbstractNode node) {
        String[] substrings;
        boolean matchs;
        if ((this.flags & 1) != 0 && (node.getFlags() & 1) == 0) {
            return false;
        }
        if ((this.flags & 2) != 0 && (node.getFlags() & 2) == 0) {
            return false;
        }
        if ((this.flags & 4) != 0 && !Glob.matchIgnoreCase(this.filter.snmpOid, node.getSnmpOID())) {
            return false;
        }
        if ((this.flags & 0x80) != 0) {
            matchs = false;
            substrings = this.filter.toolOS.split(",");
            int i = 0;
            while (i < substrings.length) {
                if (Pattern.matches(substrings[i], node.getPlatformName())) {
                    matchs = true;
                }
                ++i;
            }
            if (!matchs) {
                return false;
            }
        }
        if ((this.flags & 0x100) != 0) {
            matchs = false;
            substrings = this.filter.toolTemplate.split(",");
            Set<AbstractObject> parents = node.getAllParents(8);
            for (AbstractObject parent : parents) {
                int i = 0;
                while (i < substrings.length) {
                    if (Pattern.matches(substrings[i], parent.getObjectName())) {
                        matchs = true;
                    }
                    ++i;
                }
            }
            if (!matchs) {
                return false;
            }
        }
        return true;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSnmpOid() {
        return this.filter.snmpOid;
    }

    public String getData() {
        return this.data;
    }

    public String getConfirmationText() {
        return this.confirmationText;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getCommandDisplayName() {
        if (this.commandName != null && !this.commandName.isEmpty()) {
            return this.commandName;
        }
        return this.displayName;
    }

    public String getCommandShortName() {
        return this.commandShortName;
    }

    public String getCommandShortDisplayName() {
        if (this.commandShortName != null && !this.commandShortName.isEmpty()) {
            return this.commandShortName;
        }
        return this.getCommandDisplayName();
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public String getToolOS() {
        return this.filter.toolOS;
    }

    public String getToolTemplate() {
        return this.filter.toolTemplate;
    }
}

