/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.DciDataRow;
import org.netxms.ui.eclipse.charts.api.ChartDciConfig;
import org.netxms.ui.eclipse.charts.api.DataComparisonChart;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ViewRefreshController;

public abstract class ComparisonChartElement
extends ElementWidget {
    protected DataComparisonChart chart;
    protected NXCSession session = (NXCSession)ConsoleSharedData.getSession();
    protected int refreshInterval = 30;
    private ViewRefreshController refreshController;
    private boolean updateInProgress = false;

    public ComparisonChartElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        this.setLayout((Layout)new FillLayout());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ComparisonChartElement.this.refreshController != null) {
                    ComparisonChartElement.this.refreshController.dispose();
                }
            }
        });
    }

    protected void startRefreshTimer() {
        this.refreshController = new ViewRefreshController(this.viewPart, this.refreshInterval, new Runnable(){

            @Override
            public void run() {
                if (ComparisonChartElement.this.isDisposed()) {
                    return;
                }
                ComparisonChartElement.this.refreshData(ComparisonChartElement.this.getDciList());
            }
        });
        this.refreshData(this.getDciList());
    }

    protected void refreshData(final ChartDciConfig[] dciList) {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.ComparisonChartElement_JobTitle, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.dashboard", "org.netxms.ui.eclipse.dashboard"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final DciData[] data = new DciData[dciList.length];
                int i = 0;
                while (i < dciList.length) {
                    data[i] = dciList[i].type == 1 ? ComparisonChartElement.this.session.getCollectedData(dciList[i].nodeId, dciList[i].dciId, null, null, 1) : ComparisonChartElement.this.session.getCollectedTableData(dciList[i].nodeId, dciList[i].dciId, dciList[i].instance, dciList[i].column, null, null, 1);
                    ++i;
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!((Widget)(this).ComparisonChartElement.this.chart).isDisposed()) {
                            int i = 0;
                            while (i < data.length) {
                                DciDataRow lastValue = data[i].getLastValue();
                                (this).ComparisonChartElement.this.chart.updateParameter(i, lastValue, data[i].getDataType(), false);
                                ++i;
                            }
                            (this).ComparisonChartElement.this.chart.refresh();
                            (this).ComparisonChartElement.this.chart.clearErrors();
                        }
                        ComparisonChartElement.this.updateInProgress = false;
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ComparisonChartElement_JobError;
            }

            protected void jobFailureHandler() {
                ComparisonChartElement.this.updateInProgress = false;
                super.jobFailureHandler();
            }

            protected IStatus createFailureStatus(final Exception e) {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).ComparisonChartElement.this.chart.addError(String.valueOf(this.getErrorMessage()) + " (" + e.getLocalizedMessage() + ")");
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.start();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (hHint == -1 && size.y < 250) {
            size.y = 250;
        }
        return size;
    }

    protected abstract ChartDciConfig[] getDciList();
}

