/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets.internal;

import java.util.Map;
import java.util.Set;
import org.netxms.ui.eclipse.charts.api.ChartDciConfig;
import org.netxms.ui.eclipse.dashboard.dialogs.helpers.DciIdMatchingData;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementConfig;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;

public abstract class AbstractChartConfig
extends DashboardElementConfig {
    @ElementArray(required=true)
    private ChartDciConfig[] dciList = new ChartDciConfig[0];
    @Element(required=false)
    private String title = "";
    @Element(required=false)
    private int legendPosition = 2;
    @Element(required=false)
    private boolean showLegend = true;
    @Element(required=false)
    private boolean showTitle = true;
    @Element(required=false)
    private boolean autoScale = true;
    @Element(required=false)
    private int refreshRate = 30;
    @Element(required=false)
    private int minYScaleValue = 0;
    @Element(required=false)
    private int maxYScaleValue = 100;

    @Override
    public Set<Long> getObjects() {
        Set<Long> objects = super.getObjects();
        ChartDciConfig[] chartDciConfigArray = this.dciList;
        int n = this.dciList.length;
        int n2 = 0;
        while (n2 < n) {
            ChartDciConfig dci = chartDciConfigArray[n2];
            objects.add(dci.nodeId);
            ++n2;
        }
        return objects;
    }

    @Override
    public Map<Long, Long> getDataCollectionItems() {
        Map<Long, Long> items = super.getDataCollectionItems();
        ChartDciConfig[] chartDciConfigArray = this.dciList;
        int n = this.dciList.length;
        int n2 = 0;
        while (n2 < n) {
            ChartDciConfig dci = chartDciConfigArray[n2];
            items.put(dci.dciId, dci.nodeId);
            ++n2;
        }
        return items;
    }

    @Override
    public void remapDataCollectionItems(Map<Long, DciIdMatchingData> remapData) {
        super.remapDataCollectionItems(remapData);
        ChartDciConfig[] chartDciConfigArray = this.dciList;
        int n = this.dciList.length;
        int n2 = 0;
        while (n2 < n) {
            ChartDciConfig dci = chartDciConfigArray[n2];
            DciIdMatchingData md = remapData.get(dci.dciId);
            if (md != null) {
                dci.dciId = md.dstDciId;
                dci.nodeId = md.dstNodeId;
            }
            ++n2;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ChartDciConfig[] getDciList() {
        return this.dciList;
    }

    public void setDciList(ChartDciConfig[] dciList) {
        this.dciList = dciList;
    }

    public int getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(int legendPosition) {
        this.legendPosition = legendPosition;
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(boolean showTitle) {
        this.showTitle = showTitle;
    }

    public int getMinYScaleValue() {
        return this.minYScaleValue;
    }

    public void setMinYScaleValue(int minYScaleValue) {
        this.minYScaleValue = minYScaleValue;
    }

    public int getMaxYScaleValue() {
        return this.maxYScaleValue;
    }

    public void setMaxYScaleValue(int maxYScaleValue) {
        this.maxYScaleValue = maxYScaleValue;
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }
}

