/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.policymanager.dialogs;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectTree;
import org.netxms.ui.eclipse.policymanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class SelectInstallTargetDialog
extends Dialog {
    public static final int INSTALL_ON_CURRENT = 0;
    public static final int INSTALL_ON_SELECTED = 1;
    private Button radioInstallOnCurrent;
    private Button radioInstallOnSelected;
    private ObjectTree objectTree;
    private int installMode;
    private AbstractObject[] selectedObjects;

    public SelectInstallTargetDialog(Shell parentShell, int initialMode) {
        super(parentShell);
        this.installMode = initialMode;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.SelectInstallTargetDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectInstallTargetDialog.this.objectTree.setEnabled(SelectInstallTargetDialog.this.radioInstallOnSelected.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.radioInstallOnCurrent = new Button(dialogArea, 16);
        Messages.get();
        this.radioInstallOnCurrent.setText(Messages.SelectInstallTargetDialog_InstallOnAlreadyInstalled);
        this.radioInstallOnCurrent.setSelection(this.installMode == 0);
        this.radioInstallOnCurrent.addSelectionListener(listener);
        this.radioInstallOnSelected = new Button(dialogArea, 16);
        Messages.get();
        this.radioInstallOnSelected.setText(Messages.SelectInstallTargetDialog_InstallOnSelected);
        this.radioInstallOnSelected.setSelection(this.installMode == 1);
        this.radioInstallOnSelected.addSelectionListener(listener);
        long[] rootObjects = null;
        Object value = ConsoleSharedData.getProperty((String)"PolicyManager.rootObjects");
        if (value != null && value instanceof long[]) {
            rootObjects = (long[])value;
        }
        this.objectTree = new ObjectTree(dialogArea, 2048, 1, rootObjects, ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 300;
        this.objectTree.setLayoutData((Object)gd);
        this.objectTree.setEnabled(this.installMode == 1);
        return dialogArea;
    }

    protected void okPressed() {
        this.installMode = this.radioInstallOnCurrent.getSelection() ? 0 : 1;
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        List objects = session.findMultipleObjects(this.objectTree.getCheckedObjects(), false);
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            AbstractObject o = (AbstractObject)it.next();
            if (o instanceof Node) continue;
            it.remove();
        }
        this.selectedObjects = objects.toArray(new AbstractObject[0]);
        super.okPressed();
    }

    public int getInstallMode() {
        return this.installMode;
    }

    public AbstractObject[] getSelectedObjects() {
        return this.selectedObjects;
    }
}

