/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.topology.WirelessStation;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class WirelessStationLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        WirelessStation ws = (WirelessStation)element;
        switch (columnIndex) {
            case 0: {
                return ws.getMacAddress().toString();
            }
            case 1: {
                if (ws.getIpAddress() == null || ws.getIpAddress().isAnyLocalAddress()) {
                    return "";
                }
                return ws.getIpAddress().getHostAddress();
            }
            case 2: {
                if (ws.getNodeObjectId() == 0L) {
                    return "";
                }
                return this.session.getObjectName(ws.getNodeObjectId());
            }
            case 3: {
                return this.session.getObjectName(ws.getAccessPointId());
            }
            case 4: {
                return ws.getRadioInterface();
            }
            case 5: {
                return ws.getSsid();
            }
        }
        return null;
    }
}

