/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.datacollection.DciSummaryTableColumn;

public class DciSummaryTable {
    private int id;
    private String menuPath;
    private String title;
    private int flags;
    private String nodeFilter;
    private List<DciSummaryTableColumn> columns;

    public DciSummaryTable(String menuPath, String title) {
        this.id = 0;
        this.menuPath = menuPath;
        this.title = title;
        this.flags = 0;
        this.nodeFilter = "";
        this.columns = new ArrayList<DciSummaryTableColumn>();
    }

    public DciSummaryTable(NXCPMessage msg) {
        this.id = msg.getFieldAsInt32(444L);
        this.menuPath = msg.getFieldAsString(445L);
        this.title = msg.getFieldAsString(447L);
        this.flags = msg.getFieldAsInt32(13L);
        this.nodeFilter = msg.getFieldAsString(232L);
        String s = msg.getFieldAsString(446L);
        if (s != null && s.length() > 0) {
            String[] parts = s.split("\\^\\~\\^");
            this.columns = new ArrayList<DciSummaryTableColumn>(parts.length);
            int i = 0;
            while (i < parts.length) {
                String[] data = parts[i].split("\\^\\#\\^");
                if (data.length == 2) {
                    this.columns.add(new DciSummaryTableColumn(data[0], data[1], 0));
                } else if (data.length == 3) {
                    int flags;
                    try {
                        flags = Integer.parseInt(data[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        flags = 0;
                    }
                    this.columns.add(new DciSummaryTableColumn(data[0], data[1], flags));
                }
                ++i;
            }
        } else {
            this.columns = new ArrayList<DciSummaryTableColumn>(0);
        }
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setFieldInt32(444L, this.id);
        msg.setField(445L, this.menuPath);
        msg.setField(447L, this.title);
        msg.setFieldInt32(13L, this.flags);
        msg.setField(232L, this.nodeFilter);
        StringBuilder sb = new StringBuilder();
        for (DciSummaryTableColumn c : this.columns) {
            if (sb.length() > 0) {
                sb.append("^~^");
            }
            sb.append(c.getName());
            sb.append("^#^");
            sb.append(c.getDciName());
            sb.append("^#^");
            sb.append(c.getFlags());
        }
        msg.setField(446L, sb.toString());
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getMenuPath() {
        return this.menuPath;
    }

    public void setMenuPath(String menuPath) {
        this.menuPath = menuPath;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getNodeFilter() {
        return this.nodeFilter;
    }

    public void setNodeFilter(String nodeFilter) {
        this.nodeFilter = nodeFilter;
    }

    public List<DciSummaryTableColumn> getColumns() {
        return this.columns;
    }
}

