/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.dialogs;

import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.widgets.DateTimeSelector;

public class HistoricalDataSelectionDialog
extends Dialog {
    private int maxRecords;
    private Date timeFrom;
    private Date timeTo;
    private Button radioLastRecords;
    private Button radioTimeFrame;
    private Spinner spinnerRecords;
    private DateTimeSelector dtsFrom;
    private DateTimeSelector dtsTo;

    public HistoricalDataSelectionDialog(Shell parentShell, int maxRecords, Date timeFrom, Date timeTo) {
        super(parentShell);
        this.maxRecords = maxRecords;
        this.timeFrom = timeFrom;
        this.timeTo = timeTo;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.HistoricalDataSelectionDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 3;
        dialogArea.setLayout((Layout)layout);
        this.radioLastRecords = new Button(dialogArea, 16);
        Messages.get();
        this.radioLastRecords.setText(Messages.HistoricalDataSelectionDialog_LastRecords);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.radioLastRecords.setLayoutData((Object)gd);
        this.radioLastRecords.setSelection(this.maxRecords != 0);
        this.spinnerRecords = new Spinner(dialogArea, 2048);
        this.spinnerRecords.setMinimum(1);
        this.spinnerRecords.setMaximum(65535);
        this.spinnerRecords.setSelection(this.maxRecords);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.spinnerRecords.setLayoutData((Object)gd);
        this.spinnerRecords.setEnabled(this.radioLastRecords.getSelection());
        this.radioTimeFrame = new Button(dialogArea, 16);
        Messages.get();
        this.radioTimeFrame.setText(Messages.HistoricalDataSelectionDialog_TimeFrame);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.verticalIndent = 5;
        this.radioTimeFrame.setLayoutData((Object)gd);
        this.radioTimeFrame.setSelection(this.maxRecords == 0);
        this.dtsFrom = new DateTimeSelector(dialogArea, 0);
        this.dtsFrom.setValue(this.timeFrom);
        this.dtsFrom.setEnabled(this.radioTimeFrame.getSelection());
        new Label(dialogArea, 0).setText("  -  ");
        this.dtsTo = new DateTimeSelector(dialogArea, 0);
        this.dtsTo.setValue(this.timeTo);
        this.dtsTo.setEnabled(this.radioTimeFrame.getSelection());
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HistoricalDataSelectionDialog.this.spinnerRecords.setEnabled(HistoricalDataSelectionDialog.this.radioLastRecords.getSelection());
                HistoricalDataSelectionDialog.this.dtsFrom.setEnabled(HistoricalDataSelectionDialog.this.radioTimeFrame.getSelection());
                HistoricalDataSelectionDialog.this.dtsTo.setEnabled(HistoricalDataSelectionDialog.this.radioTimeFrame.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.radioLastRecords.addSelectionListener(listener);
        this.radioTimeFrame.addSelectionListener(listener);
        return dialogArea;
    }

    protected void okPressed() {
        if (this.radioLastRecords.getSelection()) {
            this.maxRecords = this.spinnerRecords.getSelection();
            this.timeFrom = null;
            this.timeTo = null;
        } else {
            this.maxRecords = 0;
            this.timeFrom = this.dtsFrom.getValue();
            this.timeTo = this.dtsTo.getValue();
        }
        super.okPressed();
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public Date getTimeFrom() {
        return this.timeFrom;
    }

    public Date getTimeTo() {
        return this.timeTo;
    }
}

