/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.propertypages.helpers;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.charts.api.ChartDciConfig;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DciListLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private NXCSession session;
    private Map<NodeItemPair, String> dciNameCache = new HashMap<NodeItemPair, String>();
    private List<ChartDciConfig> elementList;

    public DciListLabelProvider(List<ChartDciConfig> elementList) {
        this.elementList = elementList;
        this.session = (NXCSession)ConsoleSharedData.getSession();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ChartDciConfig dci = (ChartDciConfig)element;
        switch (columnIndex) {
            case 0: {
                return Integer.toString(this.elementList.indexOf(dci) + 1);
            }
            case 1: {
                AbstractObject object = this.session.findObjectById(dci.nodeId);
                return object != null ? object.getObjectName() : "[" + Long.toString(dci.nodeId) + "]";
            }
            case 2: {
                String string;
                String name = this.dciNameCache.get(new NodeItemPair(dci.nodeId, dci.dciId));
                if (name != null) {
                    string = name;
                } else {
                    Messages.get();
                    string = Messages.DciListLabelProvider_Unresolved;
                }
                return string;
            }
            case 3: {
                return dci.name;
            }
            case 4: {
                String string;
                if (dci.color.equalsIgnoreCase("UNSET")) {
                    Messages.get();
                    string = Messages.DciListLabelProvider_Auto;
                } else {
                    string = dci.color;
                }
                return string;
            }
        }
        return null;
    }

    public void resolveDciNames(final Collection<ChartDciConfig> dciList) {
        Messages.get();
        new ConsoleJob(Messages.DciListLabelProvider_ResolveJobName, null, "org.netxms.ui.eclipse.perfview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                long[] nodeIds = new long[dciList.size()];
                long[] dciIds = new long[dciList.size()];
                int i = 0;
                for (ChartDciConfig dci : dciList) {
                    nodeIds[i] = dci.nodeId;
                    dciIds[i] = dci.dciId;
                    ++i;
                }
                final String[] names = DciListLabelProvider.this.session.resolveDciNames(nodeIds, dciIds);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        int i = 0;
                        for (ChartDciConfig dci : dciList) {
                            DciListLabelProvider.this.dciNameCache.put(new NodeItemPair(dci.nodeId, dci.dciId), names[i++]);
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.DciListLabelProvider_ResolveJobError;
            }
        }.runInForeground();
    }

    public void addCacheEntry(long nodeId, long dciId, String name) {
        this.dciNameCache.put(new NodeItemPair(nodeId, dciId), name);
    }

    private class NodeItemPair {
        long nodeId;
        long dciId;

        public NodeItemPair(long nodeId, long dciId) {
            this.nodeId = nodeId;
            this.dciId = dciId;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (int)(this.dciId ^ this.dciId >>> 32);
            result = 31 * result + (int)(this.nodeId ^ this.nodeId >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeItemPair other = (NodeItemPair)obj;
            if (this.dciId != other.dciId) {
                return false;
            }
            return this.nodeId == other.nodeId;
        }
    }
}

