/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import jnr.constants.platform.Sysconf;
import jnr.ffi.Pointer;
import jnr.ffi.mapper.FromNativeContext;
import jnr.posix.BaseNativePOSIX;
import jnr.posix.FileStat;
import jnr.posix.LibCProvider;
import jnr.posix.MacOSFileStat;
import jnr.posix.MacOSPasswd;
import jnr.posix.NativeTimes;
import jnr.posix.POSIXHandler;
import jnr.posix.Times;

final class MacOSPOSIX
extends BaseNativePOSIX {
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new MacOSPasswd((Pointer)arg) : null;
        }
    };

    MacOSPOSIX(String libraryName, LibCProvider libcProvider, POSIXHandler handler) {
        super(libraryName, libcProvider, handler);
    }

    public FileStat allocateStat() {
        return new MacOSFileStat(this);
    }

    public int lchmod(String filename, int mode) {
        try {
            return this.libc().lchmod(filename, mode);
        }
        catch (UnsatisfiedLinkError ex) {
            this.handler.unimplementedError("lchmod");
            return -1;
        }
    }

    public int lchown(String filename, int user, int group) {
        try {
            return super.lchown(filename, user, group);
        }
        catch (UnsatisfiedLinkError ex) {
            this.handler.unimplementedError("lchown");
            return -1;
        }
    }

    public long sysconf(Sysconf name) {
        return this.libc().sysconf(name);
    }

    public Times times() {
        return NativeTimes.times(this);
    }
}

