/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.InetAddressEx;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.ClusterResource;
import org.netxms.client.objects.GenericObject;

public class Cluster
extends GenericObject {
    private int clusterType;
    private List<InetAddressEx> syncNetworks = new ArrayList<InetAddressEx>(1);
    private List<ClusterResource> resources = new ArrayList<ClusterResource>();
    private long zoneId;

    public Cluster(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        int i;
        this.clusterType = msg.getFieldAsInt32(262L);
        this.zoneId = msg.getFieldAsInt64(147L);
        int count2 = msg.getFieldAsInt32(263L);
        long fieldId = 0x28000000L;
        for (i = 0; i < count2; ++i) {
            this.syncNetworks.add(msg.getFieldAsInetAddressEx(fieldId++));
        }
        count2 = msg.getFieldAsInt32(265L);
        fieldId = 0x20000000L;
        i = 0;
        while (i < count2) {
            this.resources.add(new ClusterResource(msg, fieldId));
            ++i;
            fieldId += 10L;
        }
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    @Override
    public boolean isAlarmsVisible() {
        return true;
    }

    public int getClusterType() {
        return this.clusterType;
    }

    public List<InetAddressEx> getSyncNetworks() {
        return this.syncNetworks;
    }

    public List<ClusterResource> getResources() {
        return this.resources;
    }

    @Override
    public String getObjectClassName() {
        return "Cluster";
    }

    public long getZoneId() {
        return this.zoneId;
    }
}

