/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting;

import com.radensolutions.reporting.AppContextConfig;
import com.radensolutions.reporting.service.Connector;
import com.radensolutions.reporting.service.ReportManager;
import com.radensolutions.reporting.service.ServerSettings;
import java.io.IOException;
import java.util.Set;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class Launcher {
    private static final Logger log = LoggerFactory.getLogger(Launcher.class);
    private static final Object shutdownLatch = new Object();

    public static void main(String[] args) {
        try {
            if (args.length > 0 && args[0].equalsIgnoreCase("start")) {
                Launcher.start();
            } else if (args.length > 0 && args[0].equalsIgnoreCase("stop")) {
                Launcher.stop();
            } else {
                Launcher.registerShutdownHook();
                Launcher.start();
            }
        }
        catch (IOException e) {
            log.error("Application error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void start() throws IOException {
        log.info("Starting up");
        log.debug("Creating context");
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        context.register(new Class[]{AppContextConfig.class});
        context.refresh();
        context.registerShutdownHook();
        Launcher.registerReportingDataSources(context);
        Connector connector = (Connector)context.getBean(Connector.class);
        connector.start();
        log.info("Connector started");
        DefaultJasperReportsContext jrContext = DefaultJasperReportsContext.getInstance();
        jrContext.setProperty("net.sf.jasperreports.query.executer.factory.nxcl", "com.radensolutions.reporting.custom.NXCLQueryExecutorFactory");
        ReportManager reportManager = (ReportManager)context.getBean(ReportManager.class);
        reportManager.deploy();
        log.info("All reports successful deployed");
        while (true) {
            Object object = shutdownLatch;
            synchronized (object) {
                try {
                    shutdownLatch.wait();
                    break;
                }
                catch (InterruptedException e) {
                }
            }
        }
        log.info("Shutdown initiated");
        connector.stop();
        log.info("Connector stopped");
    }

    private static void registerReportingDataSources(AnnotationConfigApplicationContext context) {
        ServerSettings settings = (ServerSettings)context.getBean(ServerSettings.class);
        Set<String> registeredDataSources = settings.getReportingDataSources();
        for (String name : registeredDataSources) {
            RootBeanDefinition definition = new RootBeanDefinition(BasicDataSource.class);
            ServerSettings.DataSourceConfig dataSourceConfig = settings.getDataSourceConfig(name);
            definition.getPropertyValues().add("driverClassName", (Object)dataSourceConfig.getDriver());
            definition.getPropertyValues().add("url", (Object)dataSourceConfig.getUrl());
            definition.getPropertyValues().add("username", (Object)dataSourceConfig.getUsername());
            definition.getPropertyValues().add("password", (Object)dataSourceConfig.getPassword());
            context.registerBeanDefinition(name, (BeanDefinition)definition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stop() {
        Object object = shutdownLatch;
        synchronized (object) {
            shutdownLatch.notify();
        }
    }

    private static void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Launcher.stop();
            }
        });
    }
}

