/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.IfxDebugDataInputStream;
import com.informix.asf.IfxDebugDataOutputStream;
import com.informix.asf.SqliDbg$1;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;

public class SqliDbg {
    private static int sqliTraceNum = 0;
    private static final byte[] sqliHeader = new byte[]{83, 81, 76, 73, 0, 0, 0, 1};
    private IfxDebugDataInputStream in;
    private IfxDebugDataOutputStream out;
    private OutputStream traceOut;
    private int myTraceNum;
    private static long runid = System.currentTimeMillis();

    private static synchronized int getNextTraceNum() {
        return sqliTraceNum++;
    }

    public static void printSqliTraceException(Exception exception) {
        System.err.println("Sqli trace file could not be generated due to exception " + exception);
    }

    public SqliDbg(IfxDebugDataInputStream ifxDebugDataInputStream, IfxDebugDataOutputStream ifxDebugDataOutputStream, String string) {
        this.in = ifxDebugDataInputStream;
        this.out = ifxDebugDataOutputStream;
        try {
            this.myTraceNum = SqliDbg.getNextTraceNum();
            String string2 = string + runid + "." + this.myTraceNum;
            this.traceOut = (OutputStream)AccessController.doPrivileged(new SqliDbg$1(this, string2));
            this.traceOut.write(sqliHeader);
        }
        catch (Exception exception) {
            SqliDbg.printSqliTraceException(exception);
        }
    }

    public void recordS2C() {
        try {
            this.traceOut.write(83);
            this.traceOut.write(67);
            this.traceOut.write(SqliDbg.marshallInteger(this.in.getTraceLength()));
            this.traceOut.write(SqliDbg.marshallLong(this.getTimeStamp()));
            this.in.dumpTrace(this.traceOut);
            this.traceOut.flush();
        }
        catch (Exception exception) {
            SqliDbg.printSqliTraceException(exception);
        }
    }

    public void recordC2S() {
        try {
            this.traceOut.write(67);
            this.traceOut.write(83);
            this.traceOut.write(SqliDbg.marshallInteger(this.out.getTraceLength()));
            this.traceOut.write(SqliDbg.marshallLong(this.getTimeStamp()));
            this.out.dumpTrace(this.traceOut);
            this.traceOut.flush();
        }
        catch (Exception exception) {
            SqliDbg.printSqliTraceException(exception);
        }
    }

    private long getTimeStamp() {
        long l = System.currentTimeMillis();
        long l2 = l / 1000L;
        long l3 = l % 1000L * 1000L;
        double d2 = (double)l2 + (double)l3 / 1000000.0;
        return Double.doubleToLongBits(d2);
    }

    protected static byte[] marshallShort(int n) {
        byte[] byArray = new byte[2];
        byArray[1] = (byte)(n >> 8 & 0xFF);
        byArray[2] = (byte)(n >> 0 & 0xFF);
        return byArray;
    }

    protected static byte[] marshallInteger(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 0 & 0xFF)};
        return byArray;
    }

    protected static byte[] marshallLong(long l) {
        byte[] byArray = new byte[]{(byte)(l >> 56 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 0 & 0xFFL)};
        return byArray;
    }

    public void finalize() {
        try {
            this.traceOut.flush();
            this.traceOut.close();
        }
        catch (IOException iOException) {
            System.err.println("An error occured while finalizing the trace file.");
        }
    }
}

