/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.events.EventProcessingPolicy;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.ui.eclipse.epp.Activator;
import org.netxms.ui.eclipse.epp.Messages;
import org.netxms.ui.eclipse.epp.dialogs.helpers.RuleComparator;
import org.netxms.ui.eclipse.epp.dialogs.helpers.RuleLabelProvider;
import org.netxms.ui.eclipse.epp.dialogs.helpers.RuleListFilter;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class RuleSelectionDialog
extends Dialog {
    private List<EventProcessingPolicyRule> rulesCache;
    private boolean multiSelection = true;
    private Text filterText;
    private TableViewer viewer;
    private RuleListFilter filter;
    private List<EventProcessingPolicyRule> selectedRules = new ArrayList<EventProcessingPolicyRule>();

    public RuleSelectionDialog(Shell parentShell, List<EventProcessingPolicyRule> rulesCache) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.rulesCache = rulesCache;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.RuleSelectionDialog_Title);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("SelectRule.cx"), settings.getInt("SelectRule.cy"));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    protected Control createDialogArea(Composite parent) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        Messages.get();
        label.setText(Messages.ActionSelectionDialog_Filter);
        this.filterText = new Text(dialogArea, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.filterText.setLayoutData((Object)gd);
        String filterString = settings.get("SelectRule.Filter");
        if (filterString != null) {
            this.filterText.setText(filterString);
        }
        this.viewer = new TableViewer(dialogArea, 0x10800 | (this.multiSelection ? 2 : 4) | 0x100 | 0x200);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new RuleComparator());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RuleLabelProvider());
        this.filter = new RuleListFilter();
        if (filterString != null) {
            this.filter.setFilterString(filterString);
        }
        this.viewer.addFilter((ViewerFilter)this.filter);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 350;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RuleSelectionDialog.this.filter.setFilterString(RuleSelectionDialog.this.filterText.getText());
                RuleSelectionDialog.this.viewer.refresh();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RuleSelectionDialog.this.okPressed();
            }
        });
        if (this.rulesCache == null) {
            this.viewer.getTable().setEnabled(false);
            this.getButton(0).setEnabled(false);
            final NXCSession session = ConsoleSharedData.getSession();
            Messages.get();
            ConsoleJob job = new ConsoleJob(Messages.RuleSelectionDialog_JobTitle, null, "org.netxms.ui.eclipse.epp", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    final EventProcessingPolicy policy = session.getEventProcessingPolicy();
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            RuleSelectionDialog.this.viewer.getTable().setEnabled(true);
                            RuleSelectionDialog.this.getButton(0).setEnabled(true);
                            RuleSelectionDialog.this.viewer.setInput((Object)policy.getRules().toArray());
                        }
                    });
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.RuleSelectionDialog_JobError;
                }
            };
            job.setUser(false);
            job.start();
        } else {
            this.viewer.setInput((Object)this.rulesCache.toArray());
        }
        return dialogArea;
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object o : selection.toList()) {
            this.selectedRules.add((EventProcessingPolicyRule)o);
        }
        this.saveSettings();
        super.okPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("SelectRule.cx", size.x);
        settings.put("SelectRule.cy", size.y);
        settings.put("SelectRule.Filter", this.filterText.getText());
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelection;
    }

    public void enableMultiSelection(boolean enable) {
        this.multiSelection = enable;
    }

    public List<EventProcessingPolicyRule> getSelectedRules() {
        return this.selectedRules;
    }
}

