/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class NodePolling
extends PropertyPage {
    private AbstractNode object;
    private ObjectSelector pollerNode;
    private Button radioDefault;
    private Button radioEnable;
    private Button radioDisable;
    private List<Button> flagButtons = new ArrayList<Button>();
    private List<Integer> flagValues = new ArrayList<Integer>();

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AbstractNode)this.getElement().getAdapter(AbstractNode.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Group servicePollGroup = new Group(dialogArea, 0);
        Messages.get();
        servicePollGroup.setText(Messages.NodePolling_GroupNetSrv);
        layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.numColumns = 2;
        servicePollGroup.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        servicePollGroup.setLayoutData((Object)gd);
        this.pollerNode = new ObjectSelector((Composite)servicePollGroup, 0, true);
        Messages.get();
        this.pollerNode.setLabel(Messages.NodePolling_PollerNode);
        this.pollerNode.setObjectClass(AbstractNode.class);
        Messages.get();
        this.pollerNode.setEmptySelectionName(Messages.NodePolling_EmptySelectionServer);
        this.pollerNode.setObjectId(this.object.getPollerNodeId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.pollerNode.setLayoutData((Object)gd);
        Label label = new Label((Composite)servicePollGroup, 64);
        Messages.get();
        label.setText(Messages.NodePolling_PollerNodeDescription);
        gd = new GridData();
        gd.widthHint = 250;
        label.setLayoutData((Object)gd);
        Group optionsGroup = new Group(dialogArea, 0);
        Messages.get();
        optionsGroup.setText(Messages.NodePolling_GroupOptions);
        layout = new GridLayout();
        layout.verticalSpacing = 5;
        optionsGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        Messages.get();
        this.addFlag((Composite)optionsGroup, 0x2000000, Messages.NodePolling_OptDisableAgent);
        Messages.get();
        this.addFlag((Composite)optionsGroup, 0x1000000, Messages.NodePolling_OptDisableSNMP);
        Messages.get();
        this.addFlag((Composite)optionsGroup, 0x4000000, Messages.NodePolling_OptDisableICMP);
        Messages.get();
        this.addFlag((Composite)optionsGroup, 0x10000000, Messages.NodePolling_OptDisableStatusPoll);
        Messages.get();
        this.addFlag((Composite)optionsGroup, 0x20000000, Messages.NodePolling_OptDisableConfigPoll);
        Messages.get();
        this.addFlag((Composite)optionsGroup, 0x40000000, Messages.NodePolling_OptDisableRTPoll);
        Messages.get();
        this.addFlag((Composite)optionsGroup, 0x800000, Messages.NodePolling_OptDisableTopoPoll);
        Messages.get();
        this.addFlag((Composite)optionsGroup, 0x400000, Messages.NodePolling_OptDisableDiscoveryPoll);
        Messages.get();
        this.addFlag((Composite)optionsGroup, Integer.MIN_VALUE, Messages.NodePolling_OptDisableDataCollection);
        Group ifXTableGroup = new Group(dialogArea, 0);
        Messages.get();
        ifXTableGroup.setText(Messages.NodePolling_GroupIfXTable);
        layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        ifXTableGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        ifXTableGroup.setLayoutData((Object)gd);
        this.radioDefault = new Button((Composite)ifXTableGroup, 16);
        Messages.get();
        this.radioDefault.setText(Messages.NodePolling_Default);
        this.radioDefault.setSelection(this.object.getIfXTablePolicy() == 0);
        this.radioEnable = new Button((Composite)ifXTableGroup, 16);
        Messages.get();
        this.radioEnable.setText(Messages.NodePolling_Enable);
        this.radioEnable.setSelection(this.object.getIfXTablePolicy() == 1);
        this.radioDisable = new Button((Composite)ifXTableGroup, 16);
        Messages.get();
        this.radioDisable.setText(Messages.NodePolling_Disable);
        this.radioDisable.setSelection(this.object.getIfXTablePolicy() == 2);
        return dialogArea;
    }

    private void addFlag(Composite parent, int value, String name) {
        Button button = new Button(parent, 32);
        button.setText(name);
        button.setSelection((this.object.getFlags() & value) != 0);
        this.flagButtons.add(button);
        this.flagValues.add(value);
    }

    private int collectNodeFlags() {
        int flags = this.object.getFlags();
        int i = 0;
        while (i < this.flagButtons.size()) {
            flags = this.flagButtons.get(i).getSelection() ? (flags |= this.flagValues.get(i).intValue()) : (flags &= ~this.flagValues.get(i).intValue());
            ++i;
        }
        return flags;
    }

    private int collectIfXTablePolicy() {
        if (this.radioEnable.getSelection()) {
            return 1;
        }
        if (this.radioDisable.getSelection()) {
            return 2;
        }
        return 0;
    }

    protected boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setPollerNode(this.pollerNode.getObjectId());
        md.setObjectFlags(this.collectNodeFlags());
        md.setIfXTablePolicy(this.collectIfXTablePolicy());
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.NodePolling_JobName, null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.NodePolling_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            NodePolling.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.pollerNode.setObjectId(0L);
        this.radioDefault.setSelection(true);
        this.radioDisable.setSelection(false);
        this.radioEnable.setSelection(false);
        for (Button b : this.flagButtons) {
            b.setSelection(false);
        }
    }
}

