/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.helpers.DashboardElementButton;

public abstract class CGroup
extends Canvas {
    private static final int BORDER_WIDTH = 3;
    private String text;
    private Control clientArea;
    private Font titleFont;
    private Color borderColor;
    private Color titleColor;
    private Point headerSize;
    private Action doubleClickAction = null;
    private List<DashboardElementButton> buttons = new ArrayList<DashboardElementButton>(0);

    public CGroup(Composite parent, String text) {
        super(parent, 0);
        this.text = text;
        this.setBackground(this.getParent().getBackground());
        this.borderColor = SharedColors.getColor("CGroup.Border", this.getDisplay());
        this.titleColor = SharedColors.getColor("CGroup.Title", this.getDisplay());
        FontData fd = JFaceResources.getDialogFont().getFontData()[0];
        fd.setStyle(1);
        this.titleFont = new Font((Device)this.getDisplay(), fd);
        this.setFont(this.titleFont);
        this.headerSize = WidgetHelper.getTextExtent((Control)this, text);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CGroup.this.titleFont.dispose();
            }
        });
        GridLayout layout = new GridLayout();
        layout.marginWidth = 3;
        layout.marginHeight = 3;
        layout.verticalSpacing = 3;
        layout.marginTop = this.headerSize.y + 2;
        layout.marginBottom = 2;
        this.setLayout((Layout)layout);
        this.clientArea = this.createClientAreaInternal();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                CGroup.this.doPaint(e.gc);
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (CGroup.this.doubleClickAction != null) {
                    CGroup.this.doubleClickAction.run();
                }
            }
        });
        this.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                CGroup.this.layoutButtons();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    private Control createClientAreaInternal() {
        Control ca = this.createClientArea((Composite)this);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        ca.setLayoutData((Object)gd);
        return ca;
    }

    private void doPaint(GC gc) {
        gc.setAntialias(1);
        gc.setForeground(this.borderColor);
        gc.setLineWidth(3);
        Rectangle rect = this.getClientArea();
        ++rect.x;
        rect.y += 1 + this.headerSize.y / 2;
        rect.width -= 3;
        rect.height -= 3 + this.headerSize.y / 2;
        gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 4, 4);
        gc.fillRectangle(8, 0, this.headerSize.x + 4, this.headerSize.y + 2);
        gc.setForeground(this.titleColor);
        gc.drawText(this.text, 10, 1);
    }

    protected abstract Control createClientArea(Composite var1);

    public boolean setFocus() {
        return this.clientArea.setFocus();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    protected Color getBorderColor() {
        return this.borderColor;
    }

    protected void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        for (DashboardElementButton b : this.buttons) {
            b.getControl().setBackground(borderColor);
        }
    }

    protected Color getTitleColor() {
        return this.titleColor;
    }

    protected void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public void addButton(final DashboardElementButton button) {
        Label l = new Label((Composite)this, 0);
        l.setBackground(this.getBorderColor());
        l.setImage(button.getImage());
        l.setToolTipText(button.getName());
        l.setCursor(this.getDisplay().getSystemCursor(21));
        l.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                button.getAction().run();
            }
        });
        GridData gd = new GridData();
        gd.exclude = true;
        l.setLayoutData((Object)gd);
        button.setControl((Control)l);
        this.buttons.add(button);
        this.layoutButtons();
    }

    public Action getDoubleClickAction() {
        return this.doubleClickAction;
    }

    public void setDoubleClickAction(Action doubleClickAction) {
        this.doubleClickAction = doubleClickAction;
    }

    public void replaceClientArea() {
        if (this.clientArea != null) {
            this.clientArea.dispose();
        }
        this.clientArea = this.createClientAreaInternal();
        this.layout();
    }

    private void layoutButtons() {
        int pos = this.getSize().x - 12;
        int i = this.buttons.size() - 1;
        while (i >= 0) {
            Control c = this.buttons.get(i).getControl();
            c.setSize(c.computeSize(-1, -1));
            Point cs = c.getSize();
            c.setLocation(pos - cs.x, this.headerSize.y / 2 + 3 - cs.y / 2 - 1);
            pos -= cs.x + 4;
            --i;
        }
    }
}

