/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.services;

import java.util.ServiceLoader;
import org.netxms.client.services.ServiceHandler;

public final class ServiceManager {
    private static ServiceLoader<ServiceHandler> serviceLoader = ServiceLoader.load(ServiceHandler.class);

    public static synchronized void reload(ClassLoader loader) {
        serviceLoader = ServiceLoader.load(ServiceHandler.class, loader);
    }

    public static synchronized ServiceHandler getServiceHandler(String name, Class<? extends ServiceHandler> serviceClass) {
        for (ServiceHandler s : serviceLoader) {
            if (!s.getServiceName().equals(name) || !serviceClass.isInstance(s)) continue;
            return s;
        }
        return null;
    }

    public static synchronized ServiceHandler getServiceHandler(String name) {
        for (ServiceHandler s : serviceLoader) {
            if (!s.getServiceName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public static synchronized ServiceHandler getServiceHandler(Class<? extends ServiceHandler> serviceClass) {
        for (ServiceHandler s : serviceLoader) {
            if (!serviceClass.isInstance(s)) continue;
            return s;
        }
        return null;
    }

    public static synchronized void dump() {
        for (ServiceHandler s : serviceLoader) {
            System.out.println(s.getServiceName());
        }
    }
}

