/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.netxms.client.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.client.topology.ConnectionPoint;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.topology.Messages;
import org.netxms.ui.eclipse.topology.dialogs.EnterMacAddressDlg;
import org.netxms.ui.eclipse.topology.views.HostSearchResults;

public class FindMacAddress
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public void run(IAction action) {
        EnterMacAddressDlg dlg = new EnterMacAddressDlg(this.window.getShell());
        if (dlg.open() != 0) {
            return;
        }
        final NXCSession session = ConsoleSharedData.getSession();
        final MacAddress macAddr = dlg.getMacAddress();
        Messages.get();
        new ConsoleJob(String.format(Messages.FindMacAddress_JobTitle, macAddr), null, "org.netxms.ui.eclipse.topology", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final ConnectionPoint cp = session.findConnectionPoint(macAddr);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        HostSearchResults.showConnection(cp);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.FindMacAddress_JobError, macAddr);
            }
        }.start();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

