/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.CreateInterfaceDciDialog;
import org.netxms.ui.eclipse.datacollection.dialogs.helpers.InterfaceDciInfo;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class CreateInterfraceDci
implements IObjectActionDelegate {
    private static final int IFDCI_IN_BYTES = 0;
    private static final int IFDCI_OUT_BYTES = 1;
    private static final int IFDCI_IN_BITS = 2;
    private static final int IFDCI_OUT_BITS = 3;
    private static final int IFDCI_IN_PACKETS = 4;
    private static final int IFDCI_OUT_PACKETS = 5;
    private static final int IFDCI_IN_ERRORS = 6;
    private static final int IFDCI_OUT_ERRORS = 7;
    private Shell shell;
    private ViewPart viewPart;
    private List<Interface> objects = new ArrayList<Interface>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.viewPart = targetPart instanceof ViewPart ? (ViewPart)targetPart : null;
    }

    public void run(IAction action) {
        final CreateInterfaceDciDialog dlg = new CreateInterfaceDciDialog(this.shell, this.objects.size() == 1 ? this.objects.get(0) : null);
        if (dlg.open() == 0) {
            final ArrayList<Interface> ifaces = new ArrayList<Interface>(this.objects);
            HashSet<AbstractNode> nodes = new HashSet<AbstractNode>();
            for (Interface iface : ifaces) {
                AbstractNode node = iface.getParentNode();
                if (node == null) continue;
                nodes.add(node);
            }
            final HashMap<Long, Boolean> lockRequired = new HashMap<Long, Boolean>(nodes.size());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            for (AbstractNode n : nodes) {
                IViewReference ref = page.findViewReference("org.netxms.ui.eclipse.datacollection.view.data_collection_editor", Long.toString(n.getObjectId()));
                lockRequired.put(n.getObjectId(), ref == null || ref.getView(false) == null);
            }
            final NXCSession session = ConsoleSharedData.getSession();
            Messages.get();
            new ConsoleJob(Messages.CreateInterfraceDci_JobTitle, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.datacollection", null){

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.CreateInterfraceDci_JobError;
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    InterfaceDciInfo[] dciInfo = dlg.getDciInfo();
                    Messages.get();
                    monitor.beginTask(Messages.CreateInterfraceDci_TaskName, ifaces.size() * dciInfo.length);
                    int i = 0;
                    while (i < ifaces.size()) {
                        int j = 0;
                        while (j < dciInfo.length) {
                            if (dciInfo[j].enabled) {
                                CreateInterfraceDci.createInterfaceDci(session, (Interface)ifaces.get(i), j, dciInfo[j], dlg.getPollingInterval(), dlg.getRetentionTime(), ifaces.size() > 1, lockRequired);
                            }
                            monitor.worked(1);
                            ++j;
                        }
                        ++i;
                    }
                    monitor.done();
                }
            }.start();
        }
    }

    private static void createInterfaceDci(NXCSession session, Interface iface, int dciType, InterfaceDciInfo dciInfo, int pollingInterval, int retentionTime, boolean updateDescription, Map<Long, Boolean> lockRequired) throws Exception {
        AbstractNode node = iface.getParentNode();
        if (node == null) {
            throw new NXCException(46);
        }
        DataCollectionConfiguration dcc = lockRequired.get(node.getObjectId()) != false ? session.openDataCollectionConfiguration(node.getObjectId()) : new DataCollectionConfiguration(session, node.getObjectId());
        DataCollectionItem dci = (DataCollectionItem)dcc.findItem(dcc.createItem(), DataCollectionItem.class);
        dci.setPollingInterval(pollingInterval);
        dci.setRetentionTime(retentionTime);
        if (node.hasAgent()) {
            dci.setOrigin(1);
            if (node.isAgentIfXCountersSupported()) {
                dci.setDataType(dciType != 6 && dciType != 7 ? 3 : 1);
            } else {
                dci.setDataType(1);
            }
        } else {
            dci.setOrigin(2);
            if (node.isIfXTableSupported()) {
                dci.setDataType(dciType != 6 && dciType != 7 ? 3 : 1);
            } else {
                dci.setDataType(1);
            }
        }
        dci.setStatus(0);
        dci.setDescription(updateDescription ? dciInfo.description.replaceAll("@@ifName@@", iface.getObjectName()) : dciInfo.description);
        dci.setDeltaCalculation(dciInfo.delta ? 2 : 0);
        if (dci.getOrigin() == 1) {
            switch (dciType) {
                case 0: 
                case 2: {
                    dci.setName(String.valueOf(node.isAgentIfXCountersSupported() ? "Net.Interface.BytesIn64(" : "Net.Interface.BytesIn(") + iface.getIfIndex() + ")");
                    break;
                }
                case 1: 
                case 3: {
                    dci.setName(String.valueOf(node.isAgentIfXCountersSupported() ? "Net.Interface.BytesOut64(" : "Net.Interface.BytesOut(") + iface.getIfIndex() + ")");
                    break;
                }
                case 4: {
                    dci.setName(String.valueOf(node.isAgentIfXCountersSupported() ? "Net.Interface.PacketsIn64(" : "Net.Interface.PacketsIn(") + iface.getIfIndex() + ")");
                    break;
                }
                case 5: {
                    dci.setName(String.valueOf(node.isAgentIfXCountersSupported() ? "Net.Interface.PacketsOut64(" : "Net.Interface.PacketsOut(") + iface.getIfIndex() + ")");
                    break;
                }
                case 6: {
                    dci.setName("Net.Interface.InErrors(" + iface.getIfIndex() + ")");
                    break;
                }
                case 7: {
                    dci.setName("Net.Interface.OutErrors(" + iface.getIfIndex() + ")");
                }
            }
        } else {
            switch (dciType) {
                case 0: 
                case 2: {
                    dci.setName(String.valueOf(node.isIfXTableSupported() ? ".1.3.6.1.2.1.31.1.1.1.6." : ".1.3.6.1.2.1.2.2.1.10.") + iface.getIfIndex());
                    break;
                }
                case 1: 
                case 3: {
                    dci.setName(String.valueOf(node.isIfXTableSupported() ? ".1.3.6.1.2.1.31.1.1.1.10." : ".1.3.6.1.2.1.2.2.1.16.") + iface.getIfIndex());
                    break;
                }
                case 4: {
                    dci.setName(String.valueOf(node.isIfXTableSupported() ? ".1.3.6.1.2.1.31.1.1.1.7." : ".1.3.6.1.2.1.2.2.1.11.") + iface.getIfIndex());
                    break;
                }
                case 5: {
                    dci.setName(String.valueOf(node.isIfXTableSupported() ? ".1.3.6.1.2.1.31.1.1.1.11." : ".1.3.6.1.2.1.2.2.1.17.") + iface.getIfIndex());
                    break;
                }
                case 6: {
                    dci.setName(".1.3.6.1.2.1.2.2.1.14." + iface.getIfIndex());
                    break;
                }
                case 7: {
                    dci.setName(".1.3.6.1.2.1.2.2.1.20." + iface.getIfIndex());
                }
            }
        }
        if (dciType == 2 || dciType == 3) {
            dci.setTransformationScript("return $1 * 8;");
        }
        dcc.modifyObject((DataCollectionObject)dci);
        if (lockRequired.get(node.getObjectId()).booleanValue()) {
            dcc.close();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.objects.clear();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 0) {
            for (Object o : ((IStructuredSelection)selection).toList()) {
                if (!(o instanceof Interface)) continue;
                this.objects.add((Interface)o);
            }
            action.setEnabled(this.objects.size() > 0);
        } else {
            action.setEnabled(false);
        }
    }
}

