/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views.helpers;

import java.util.HashMap;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DciLabelProvider
implements ITableLabelProvider {
    private NXCSession session;
    private Image[] statusImages;
    private HashMap<Integer, String> originTexts = new HashMap();
    private HashMap<Integer, String> dtTexts = new HashMap();
    private HashMap<Integer, String> statusTexts = new HashMap();

    public DciLabelProvider() {
        this.session = ConsoleSharedData.getSession();
        this.statusImages = new Image[3];
        this.statusImages[0] = Activator.getImageDescriptor("icons/active.gif").createImage();
        this.statusImages[1] = Activator.getImageDescriptor("icons/disabled.gif").createImage();
        this.statusImages[2] = Activator.getImageDescriptor("icons/unsupported.gif").createImage();
        Integer n = 1;
        Messages.get();
        this.originTexts.put(n, Messages.DciLabelProvider_SourceAgent);
        Integer n2 = 2;
        Messages.get();
        this.originTexts.put(n2, Messages.DciLabelProvider_SourceSNMP);
        Integer n3 = 3;
        Messages.get();
        this.originTexts.put(n3, Messages.DciLabelProvider_SourceCPSNMP);
        Integer n4 = 0;
        Messages.get();
        this.originTexts.put(n4, Messages.DciLabelProvider_SourceInternal);
        Integer n5 = 4;
        Messages.get();
        this.originTexts.put(n5, Messages.DciLabelProvider_SourcePush);
        Integer n6 = 5;
        Messages.get();
        this.originTexts.put(n6, Messages.DciLabelProvider_SourceWinPerf);
        Integer n7 = 6;
        Messages.get();
        this.originTexts.put(n7, Messages.DciLabelProvider_SourceILO);
        Integer n8 = 7;
        Messages.get();
        this.originTexts.put(n8, Messages.DciLabelProvider_SourceScript);
        Integer n9 = 0;
        Messages.get();
        this.statusTexts.put(n9, Messages.DciLabelProvider_Active);
        Integer n10 = 1;
        Messages.get();
        this.statusTexts.put(n10, Messages.DciLabelProvider_Disabled);
        Integer n11 = 2;
        Messages.get();
        this.statusTexts.put(n11, Messages.DciLabelProvider_NotSupported);
        Integer n12 = 0;
        Messages.get();
        this.dtTexts.put(n12, Messages.DciLabelProvider_DT_int32);
        Integer n13 = 1;
        Messages.get();
        this.dtTexts.put(n13, Messages.DciLabelProvider_DT_uint32);
        Integer n14 = 2;
        Messages.get();
        this.dtTexts.put(n14, Messages.DciLabelProvider_DT_int64);
        Integer n15 = 3;
        Messages.get();
        this.dtTexts.put(n15, Messages.DciLabelProvider_DT_uint64);
        Integer n16 = 5;
        Messages.get();
        this.dtTexts.put(n16, Messages.DciLabelProvider_DT_float);
        Integer n17 = 4;
        Messages.get();
        this.dtTexts.put(n17, Messages.DciLabelProvider_DT_string);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        int status = ((DataCollectionObject)element).getStatus();
        return status >= 0 && status < this.statusImages.length ? this.statusImages[status] : null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DataCollectionObject dci = (DataCollectionObject)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(dci.getId());
            }
            case 1: {
                return this.originTexts.get(dci.getOrigin());
            }
            case 2: {
                return dci.getDescription();
            }
            case 3: {
                return dci.getName();
            }
            case 4: {
                if (dci instanceof DataCollectionItem) {
                    return this.dtTexts.get(((DataCollectionItem)dci).getDataType());
                }
                Messages.get();
                return Messages.DciLabelProvider_Table;
            }
            case 5: {
                if (dci.isUseAdvancedSchedule()) {
                    Messages.get();
                    return Messages.DciLabelProvider_CustomSchedule;
                }
                return Integer.toString(dci.getPollingInterval());
            }
            case 6: {
                String string;
                int days = dci.getRetentionTime();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Integer.toString(days)));
                if (days == 1) {
                    Messages.get();
                    string = Messages.DciLabelProvider_Day;
                } else {
                    Messages.get();
                    string = Messages.DciLabelProvider_Days;
                }
                return stringBuilder.append(string).toString();
            }
            case 7: {
                return this.statusTexts.get(dci.getStatus());
            }
            case 8: {
                String string;
                if (dci.getTemplateId() == 0L) {
                    return null;
                }
                AbstractObject object = this.session.findObjectById(dci.getTemplateId());
                if (object != null) {
                    string = object.getObjectName();
                } else {
                    Messages.get();
                    string = Messages.DciLabelProvider_Unknown;
                }
                return string;
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        int i = 0;
        while (i < this.statusImages.length) {
            this.statusImages[i].dispose();
            ++i;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

