/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.netxms.base.CompatTools;
import org.netxms.base.GeoLocation;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCommon;
import org.netxms.base.PostalAddress;
import org.netxms.client.AccessListElement;
import org.netxms.client.ModuleDataProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.services.ServiceManager;

public abstract class AbstractObject {
    public static final int NETWORK = 1;
    public static final int SERVICEROOT = 2;
    public static final int TEMPLATEROOT = 3;
    public static final int ZONE0 = 4;
    public static final int POLICYROOT = 5;
    public static final int NETWORKMAPROOT = 6;
    public static final int DASHBOARDROOT = 7;
    public static final int REPORTROOT = 8;
    public static final int BUSINESSSERVICEROOT = 9;
    public static final int OBJECT_GENERIC = 0;
    public static final int OBJECT_SUBNET = 1;
    public static final int OBJECT_NODE = 2;
    public static final int OBJECT_INTERFACE = 3;
    public static final int OBJECT_NETWORK = 4;
    public static final int OBJECT_CONTAINER = 5;
    public static final int OBJECT_ZONE = 6;
    public static final int OBJECT_SERVICEROOT = 7;
    public static final int OBJECT_TEMPLATE = 8;
    public static final int OBJECT_TEMPLATEGROUP = 9;
    public static final int OBJECT_TEMPLATEROOT = 10;
    public static final int OBJECT_NETWORKSERVICE = 11;
    public static final int OBJECT_VPNCONNECTOR = 12;
    public static final int OBJECT_CONDITION = 13;
    public static final int OBJECT_CLUSTER = 14;
    public static final int OBJECT_POLICYGROUP = 15;
    public static final int OBJECT_POLICYROOT = 16;
    public static final int OBJECT_AGENTPOLICY = 17;
    public static final int OBJECT_AGENTPOLICY_CONFIG = 18;
    public static final int OBJECT_NETWORKMAPROOT = 19;
    public static final int OBJECT_NETWORKMAPGROUP = 20;
    public static final int OBJECT_NETWORKMAP = 21;
    public static final int OBJECT_DASHBOARDROOT = 22;
    public static final int OBJECT_DASHBOARD = 23;
    public static final int OBJECT_BUSINESSSERVICEROOT = 27;
    public static final int OBJECT_BUSINESSSERVICE = 28;
    public static final int OBJECT_NODELINK = 29;
    public static final int OBJECT_SLMCHECK = 30;
    public static final int OBJECT_MOBILEDEVICE = 31;
    public static final int OBJECT_RACK = 32;
    public static final int OBJECT_ACCESSPOINT = 33;
    public static final int OBJECT_CUSTOM = 10000;
    public static final int CALCULATE_DEFAULT = 0;
    public static final int CALCULATE_MOST_CRITICAL = 1;
    public static final int CALCULATE_SINGLE_THRESHOLD = 2;
    public static final int CALCULATE_MULTIPLE_THRESHOLDS = 3;
    public static final int PROPAGATE_DEFAULT = 0;
    public static final int PROPAGATE_UNCHANGED = 1;
    public static final int PROPAGATE_FIXED = 2;
    public static final int PROPAGATE_RELATIVE = 3;
    public static final int PROPAGATE_TRANSLATED = 4;
    protected NXCSession session = null;
    protected long objectId = 0L;
    protected UUID guid;
    protected String objectName;
    protected int objectClass;
    protected ObjectStatus status = ObjectStatus.UNKNOWN;
    protected boolean isDeleted = false;
    protected String comments;
    protected GeoLocation geolocation;
    protected PostalAddress postalAddress;
    protected UUID image;
    protected long submapId;
    protected HashSet<Long> trustedNodes = new HashSet(0);
    protected boolean inheritAccessRights = true;
    protected HashSet<AccessListElement> accessList = new HashSet(0);
    protected int statusCalculationMethod;
    protected int statusPropagationMethod;
    protected ObjectStatus fixedPropagatedStatus;
    protected int statusShift;
    protected ObjectStatus[] statusTransformation;
    protected int statusSingleThreshold;
    protected int[] statusThresholds;
    protected HashSet<Long> parents = new HashSet(0);
    protected HashSet<Long> children = new HashSet(0);
    protected Map<String, String> customAttributes = new HashMap<String, String>(0);
    protected Map<String, Object> moduleData = null;
    private int effectiveRights = 0;
    private boolean effectiveRightsCached = false;

    protected AbstractObject(long id, NXCSession session) {
        this.objectId = id;
        this.session = session;
        this.guid = UUID.randomUUID();
        this.objectName = "unknown";
        this.objectClass = 0;
        this.comments = "";
        this.geolocation = new GeoLocation(false);
        this.postalAddress = new PostalAddress();
        this.image = NXCommon.EMPTY_GUID;
        this.statusCalculationMethod = 0;
        this.statusPropagationMethod = 0;
        this.fixedPropagatedStatus = ObjectStatus.NORMAL;
        this.statusShift = 0;
        this.statusTransformation = new ObjectStatus[4];
        this.statusTransformation[0] = ObjectStatus.WARNING;
        this.statusTransformation[1] = ObjectStatus.MINOR;
        this.statusTransformation[2] = ObjectStatus.MAJOR;
        this.statusTransformation[3] = ObjectStatus.CRITICAL;
        this.statusSingleThreshold = 75;
        this.statusThresholds = new int[4];
        this.statusThresholds[0] = 75;
        this.statusThresholds[1] = 75;
        this.statusThresholds[2] = 75;
        this.statusThresholds[3] = 75;
    }

    public AbstractObject(NXCPMessage msg, NXCSession session) {
        this.session = session;
        this.objectId = msg.getFieldAsInt32(3L);
        this.guid = msg.getFieldAsUUID(222L);
        this.objectName = msg.getFieldAsString(4L);
        this.objectClass = msg.getFieldAsInt32(5L);
        this.isDeleted = msg.getFieldAsBoolean(30L);
        this.status = ObjectStatus.getByValue(msg.getFieldAsInt32(10L));
        this.comments = msg.getFieldAsString(82L);
        this.geolocation = new GeoLocation(msg);
        this.postalAddress = new PostalAddress(msg);
        this.image = msg.getFieldAsUUID(379L);
        this.submapId = msg.getFieldAsInt64(389L);
        if (this.image == null) {
            this.image = NXCommon.EMPTY_GUID;
        }
        this.statusCalculationMethod = msg.getFieldAsInt32(160L);
        this.statusPropagationMethod = msg.getFieldAsInt32(183L);
        this.fixedPropagatedStatus = ObjectStatus.getByValue(msg.getFieldAsInt32(184L));
        this.statusShift = msg.getFieldAsInt32(185L);
        this.statusTransformation = new ObjectStatus[4];
        this.statusTransformation[0] = ObjectStatus.getByValue(msg.getFieldAsInt32(186L));
        this.statusTransformation[1] = ObjectStatus.getByValue(msg.getFieldAsInt32(187L));
        this.statusTransformation[2] = ObjectStatus.getByValue(msg.getFieldAsInt32(188L));
        this.statusTransformation[3] = ObjectStatus.getByValue(msg.getFieldAsInt32(189L));
        this.statusSingleThreshold = msg.getFieldAsInt32(190L);
        this.statusThresholds = new int[4];
        this.statusThresholds[0] = msg.getFieldAsInt32(191L);
        this.statusThresholds[1] = msg.getFieldAsInt32(192L);
        this.statusThresholds[2] = msg.getFieldAsInt32(193L);
        this.statusThresholds[3] = msg.getFieldAsInt32(194L);
        if (this.statusShift > Short.MAX_VALUE) {
            this.statusShift -= 65536;
        }
        int count = msg.getFieldAsInt32(7L);
        int i = 0;
        long id = 12288L;
        while (i < count) {
            this.parents.add(msg.getFieldAsInt64(id));
            ++i;
            ++id;
        }
        count = msg.getFieldAsInt32(31L);
        i = 0;
        id = 0x80000000L;
        while (i < count) {
            this.children.add(msg.getFieldAsInt64(id));
            ++i;
            ++id;
        }
        count = msg.getFieldAsInt32(306L);
        if (count > 0) {
            Long[] nodes = msg.getFieldAsUInt32ArrayEx(307L);
            this.trustedNodes.addAll(Arrays.asList(nodes));
        }
        i = 0;
        id = 0x80000000L;
        while (i < count) {
            this.children.add(msg.getFieldAsInt64(id));
            ++i;
            ++id;
        }
        count = msg.getFieldAsInt32(309L);
        i = 0;
        id = 0x70000000L;
        while (i < count) {
            this.customAttributes.put(msg.getFieldAsString(id), msg.getFieldAsString(id + 1L));
            ++i;
            id += 2L;
        }
        this.inheritAccessRights = msg.getFieldAsBoolean(33L);
        count = msg.getFieldAsInt32(32L);
        i = 0;
        id = 4096L;
        long id2 = 8192L;
        while (i < count) {
            this.accessList.add(new AccessListElement(msg.getFieldAsInt64(id), msg.getFieldAsInt32(id2)));
            ++i;
            ++id;
            ++id2;
        }
        count = msg.getFieldAsInt32(476L);
        if (count > 0) {
            this.moduleData = new HashMap<String, Object>(count);
            i = 0;
            id = 0x71000000L;
            while (i < count) {
                String module = msg.getFieldAsString(id);
                ModuleDataProvider p = (ModuleDataProvider)ServiceManager.getServiceHandler(module, ModuleDataProvider.class);
                if (p != null) {
                    this.moduleData.put(module, p.createModuleData(msg, id + 1L));
                }
                ++i;
                id += 0x100000L;
            }
        }
    }

    public boolean isDefaultImage() {
        return this.image.equals(NXCommon.EMPTY_GUID);
    }

    public int getParentCount() {
        return this.parents.size();
    }

    public Iterator<Long> getParents() {
        return this.parents.iterator();
    }

    public Iterator<Long> getChildren() {
        return this.children.iterator();
    }

    public AccessListElement[] getAccessList() {
        return this.accessList.toArray(new AccessListElement[this.accessList.size()]);
    }

    public String getComments() {
        return this.comments;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public ObjectStatus getStatus() {
        return this.status;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public boolean isInheritAccessRights() {
        return this.inheritAccessRights;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChildOf(long objectId) {
        boolean rc = false;
        HashSet<Long> hashSet = this.parents;
        synchronized (hashSet) {
            for (long id : this.parents) {
                if (id == objectId) {
                    rc = true;
                    break;
                }
                AbstractObject object = this.session.findObjectById(id);
                if (object == null || !object.isChildOf(objectId)) continue;
                rc = true;
                break;
            }
        }
        return rc;
    }

    public boolean isChildOf(long[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (this.isChildOf(objects[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectChildOf(long objectId) {
        boolean rc = false;
        HashSet<Long> hashSet = this.parents;
        synchronized (hashSet) {
            for (long id : this.parents) {
                if (id != objectId) continue;
                rc = true;
                break;
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject[] getParentsAsArray() {
        HashSet<AbstractObject> list;
        HashSet<Long> hashSet = this.parents;
        synchronized (hashSet) {
            list = new HashSet<AbstractObject>(this.children.size());
            Iterator<Long> it = this.parents.iterator();
            while (it.hasNext()) {
                AbstractObject obj = this.session.findObjectById(it.next());
                if (obj == null) continue;
                list.add(obj);
            }
        }
        return list.toArray(new AbstractObject[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject[] getChildsAsArray() {
        HashSet<AbstractObject> list;
        HashSet<Long> hashSet = this.children;
        synchronized (hashSet) {
            list = new HashSet<AbstractObject>(this.children.size());
            Iterator<Long> it = this.children.iterator();
            while (it.hasNext()) {
                AbstractObject obj = this.session.findObjectById(it.next());
                if (obj == null) continue;
                list.add(obj);
            }
        }
        return list.toArray(new AbstractObject[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getChildIdList() {
        long[] list;
        HashSet<Long> hashSet = this.children;
        synchronized (hashSet) {
            list = new long[this.children.size()];
            int i = 0;
            for (Long id : this.children) {
                list[i++] = id;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getParentIdList() {
        long[] list;
        HashSet<Long> hashSet = this.parents;
        synchronized (hashSet) {
            list = new long[this.parents.size()];
            int i = 0;
            for (Long id : this.parents) {
                list[i++] = id;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAllChildsInternal(int[] classFilter, Set<AbstractObject> set) {
        HashSet<Long> hashSet = this.children;
        synchronized (hashSet) {
            Iterator<Long> it = this.children.iterator();
            while (it.hasNext()) {
                AbstractObject obj = this.session.findObjectById(it.next());
                if (obj == null) continue;
                if (classFilter == null || CompatTools.arrayContains(classFilter, obj.getObjectClass())) {
                    set.add(obj);
                }
                obj.getAllChildsInternal(classFilter, set);
            }
        }
    }

    public Set<AbstractObject> getAllChilds(int classFilter) {
        int[] nArray;
        HashSet<AbstractObject> result = new HashSet<AbstractObject>();
        if (classFilter < 0) {
            nArray = null;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = classFilter;
        }
        this.getAllChildsInternal(nArray, result);
        return result;
    }

    public Set<AbstractObject> getAllChilds(int[] classFilter) {
        HashSet<AbstractObject> result = new HashSet<AbstractObject>();
        this.getAllChildsInternal(classFilter, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAllParentsInternal(int[] classFilter, Set<AbstractObject> set) {
        HashSet<Long> hashSet = this.parents;
        synchronized (hashSet) {
            Iterator<Long> it = this.parents.iterator();
            while (it.hasNext()) {
                AbstractObject obj = this.session.findObjectById(it.next());
                if (obj == null) continue;
                if (classFilter == null || CompatTools.arrayContains(classFilter, obj.getObjectClass())) {
                    set.add(obj);
                }
                obj.getAllParentsInternal(classFilter, set);
            }
        }
    }

    public Set<AbstractObject> getAllParents(int classFilter) {
        int[] nArray;
        HashSet<AbstractObject> result = new HashSet<AbstractObject>();
        if (classFilter < 0) {
            nArray = null;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = classFilter;
        }
        this.getAllParentsInternal(nArray, result);
        return result;
    }

    public Set<AbstractObject> getAllParents(int[] classFilter) {
        HashSet<AbstractObject> result = new HashSet<AbstractObject>();
        this.getAllParentsInternal(classFilter, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject[] getTrustedNodes() {
        AbstractObject[] list;
        HashSet<Long> hashSet = this.trustedNodes;
        synchronized (hashSet) {
            list = new AbstractObject[this.trustedNodes.size()];
            Iterator<Long> it = this.trustedNodes.iterator();
            int i = 0;
            while (it.hasNext()) {
                list[i] = this.session.findObjectById(it.next());
                ++i;
            }
        }
        return list;
    }

    public boolean hasParents() {
        return this.parents.size() > 0;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public boolean hasAccessibleChildren() {
        for (Long id : this.children) {
            if (this.session.findObjectById(id) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowedOnMap() {
        return false;
    }

    public boolean isAlarmsVisible() {
        return false;
    }

    public int getObjectClass() {
        return this.objectClass;
    }

    public String getObjectClassName() {
        return "Class " + Integer.toString(this.objectClass);
    }

    public Map<String, String> getCustomAttributes() {
        return this.customAttributes;
    }

    public GeoLocation getGeolocation() {
        return this.geolocation;
    }

    public int hashCode() {
        return (int)this.objectId;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public UUID getImage() {
        return this.image;
    }

    public long getSubmapId() {
        return this.submapId;
    }

    public int getStatusCalculationMethod() {
        return this.statusCalculationMethod;
    }

    public int getStatusPropagationMethod() {
        return this.statusPropagationMethod;
    }

    public ObjectStatus getFixedPropagatedStatus() {
        return this.fixedPropagatedStatus;
    }

    public int getStatusShift() {
        return this.statusShift;
    }

    public ObjectStatus[] getStatusTransformation() {
        return this.statusTransformation;
    }

    public int getStatusSingleThreshold() {
        return this.statusSingleThreshold;
    }

    public int[] getStatusThresholds() {
        return this.statusThresholds;
    }

    public final void setSession(NXCSession session) {
        this.session = session;
    }

    public int getEffectiveRights() {
        if (this.effectiveRightsCached) {
            return this.effectiveRights;
        }
        try {
            this.effectiveRights = this.session.getEffectiveRights(this.objectId);
            this.effectiveRightsCached = true;
        }
        catch (Exception exception) {
            this.effectiveRights = 0;
        }
        return this.effectiveRights;
    }

    public Object getModuleData(String module) {
        return this.moduleData != null ? this.moduleData.get(module) : null;
    }

    public PostalAddress getPostalAddress() {
        return this.postalAddress;
    }
}

