/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withoutaxes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.PlotComputation;
import org.eclipse.birt.chart.computation.UserDataSetHints;
import org.eclipse.birt.chart.computation.withoutaxes.Coordinates;
import org.eclipse.birt.chart.computation.withoutaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.DataPoint;
import org.eclipse.birt.chart.model.attribute.DataPointComponent;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.emf.common.util.EList;

public final class PlotWithoutAxes
extends PlotComputation {
    private transient Size szCell = null;
    private transient int iRows = 0;
    private transient int iColumns = 0;
    private transient int iSeries = 0;

    public PlotWithoutAxes(IDisplayServer xs, ChartWithoutAxes cwoa, RunTimeContext rtc) {
        super(xs, rtc, cwoa);
    }

    public final void compute(Bounds bo) {
        DialChart dcw;
        this.boPlotBackground = goFactory.scaleBounds(bo, this.dPointToPixel);
        EList<SeriesDefinition> el = this.getModel().getSeriesDefinitions();
        ArrayList<Series> al = new ArrayList<Series>();
        ((ChartWithoutAxesImpl)this.getModel()).recursivelyGetSeries(el, al, 0, 0);
        Series[] sea = al.toArray(new Series[al.size()]);
        this.iSeries = sea.length;
        this.iColumns = this.getModel().getGridColumnCount();
        if (this.iColumns == 0) {
            this.iColumns = PlotWithoutAxes.getAutoColumCount(this.boPlotBackground, this.iSeries);
        }
        this.iRows = (this.iSeries - 1) / this.iColumns + 1;
        if (this.getModel() instanceof DialChart && (dcw = (DialChart)this.getModel()).isDialSuperimposition()) {
            this.iColumns = 1;
            this.iRows = 1;
        }
        this.szCell = SizeImpl.create(this.boPlotBackground.getWidth() / (double)this.iColumns, this.boPlotBackground.getHeight() / (double)this.iRows);
        this.insCA = goFactory.scaleInsets(this.getModel().getPlot().getClientArea().getInsets(), this.dPointToPixel);
    }

    private static int getAutoColumCount(Bounds boPlot, int iSeries) {
        double rat = boPlot.getHeight() / boPlot.getWidth();
        int colums = (int)Math.round(Math.sqrt((double)iSeries / rat));
        if ((colums = Math.min(colums, iSeries)) == 0) {
            ++colums;
        }
        return colums;
    }

    public final Size getCellSize() {
        return this.szCell;
    }

    public final Coordinates getCellCoordinates(int iCell) {
        return new Coordinates(iCell % this.iColumns, iCell / this.iColumns);
    }

    public final int getColumnCount() {
        return this.iColumns;
    }

    public final int getRowCount() {
        return this.iRows;
    }

    public final ChartWithoutAxes getModel() {
        return (ChartWithoutAxes)this.cm;
    }

    public final SeriesRenderingHints getSeriesRenderingHints(SeriesDefinition sdOrthogonal, Series seOrthogonal) throws ChartException, IllegalArgumentException {
        if (seOrthogonal == null || seOrthogonal.getClass() == SeriesImpl.class) {
            return null;
        }
        EList<SeriesDefinition> elCategories = this.getModel().getSeriesDefinitions();
        if (elCategories.size() != 1) {
            throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.cwoa.single.series.definition", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        SeriesDefinition sd = (SeriesDefinition)elCategories.get(0);
        List<Series> al = sd.getRunTimeSeries();
        if (al.size() != 1) {
            throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.cwoa.single.runtime.series", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        Series seBase = al.get(0);
        DataSetIterator dsiBaseValues = new DataSetIterator(seBase.getDataSet());
        DataSetIterator dsiOrthogonalValues = new DataSetIterator(seOrthogonal.getDataSet());
        DataPointHints[] dpha = null;
        if (dsiBaseValues.size() != dsiOrthogonalValues.size()) {
            logger.log(1, Messages.getString("exception.data.outofsync", new Object[]{dsiBaseValues.size(), dsiOrthogonalValues.size()}, this.rtc.getULocale()));
        } else {
            int iCount = dsiOrthogonalValues.size();
            dpha = new DataPointHints[iCount];
            DataPoint dp = seOrthogonal.getDataPoint();
            EList<DataPointComponent> el = dp.getComponents();
            FormatSpecifier fsBase = null;
            FormatSpecifier fsOrthogonal = null;
            FormatSpecifier fsSeries = null;
            FormatSpecifier fsPercentile = null;
            int i = 0;
            while (i < el.size()) {
                DataPointComponent dpc = (DataPointComponent)el.get(i);
                DataPointComponentType dpct = dpc.getType();
                if (DataPointComponentType.BASE_VALUE_LITERAL.equals((Object)dpct) && (fsBase = dpc.getFormatSpecifier()) == null) {
                    fsBase = sd.getFormatSpecifier();
                }
                if (DataPointComponentType.ORTHOGONAL_VALUE_LITERAL.equals((Object)dpct) && (fsOrthogonal = dpc.getFormatSpecifier()) == null && seOrthogonal.eContainer() instanceof SeriesDefinition) {
                    fsOrthogonal = ((SeriesDefinition)seOrthogonal.eContainer()).getFormatSpecifier();
                }
                if (DataPointComponentType.SERIES_VALUE_LITERAL.equals((Object)dpct)) {
                    fsSeries = dpc.getFormatSpecifier();
                }
                if (DataPointComponentType.PERCENTILE_ORTHOGONAL_VALUE_LITERAL.equals((Object)dpct)) {
                    fsPercentile = dpc.getFormatSpecifier();
                }
                ++i;
            }
            UserDataSetHints udsh = new UserDataSetHints(seOrthogonal.getDataSets());
            udsh.reset();
            double total = 0.0;
            int i2 = 0;
            while (i2 < iCount) {
                Object v = dsiOrthogonalValues.next();
                if (v instanceof Number) {
                    total += ((Number)v).doubleValue();
                } else if (v instanceof NumberDataElement) {
                    total += ((NumberDataElement)v).getValue();
                }
                ++i2;
            }
            dsiOrthogonalValues.reset();
            i2 = 0;
            while (i2 < iCount) {
                Object orthValue = dsiOrthogonalValues.next();
                Double percentileValue = null;
                if (total != 0.0) {
                    if (orthValue instanceof Number) {
                        percentileValue = new Double(((Number)orthValue).doubleValue() / total);
                    } else if (orthValue instanceof NumberDataElement) {
                        percentileValue = new Double(((NumberDataElement)orthValue).getValue() / total);
                    }
                } else {
                    percentileValue = new Double(0.0);
                }
                dpha[i2] = new DataPointHints(dsiBaseValues.next(), orthValue, seOrthogonal.getSeriesIdentifier(), (Object)percentileValue, seOrthogonal.getDataPoint(), fsBase, fsOrthogonal, fsSeries, fsPercentile, i2, null, -1.0, this.rtc);
                udsh.next(dpha[i2]);
                ++i2;
            }
        }
        return new SeriesRenderingHints(this, dpha, dsiBaseValues, dsiOrthogonalValues);
    }
}

