/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import java.util.HashMap;
import java.util.Map;
import jnr.ffi.Pointer;
import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.mapper.TypeMapper;
import jnr.ffi.provider.ClosureManager;
import jnr.ffi.provider.jffi.NativeClosureFactory;
import jnr.ffi.provider.jffi.NativeRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NativeClosureManager
implements ClosureManager {
    private volatile Map<Class<? extends Object>, NativeClosureFactory> factories = new HashMap<Class<? extends Object>, NativeClosureFactory>();
    private final NativeRuntime runtime;
    private final TypeMapper typeMapper;

    NativeClosureManager(NativeRuntime runtime, TypeMapper typeMapper) {
        this.runtime = runtime;
        this.typeMapper = typeMapper;
    }

    @Override
    public <T> T newClosure(Class<? extends T> closureClass, T instance) {
        NativeClosureFactory factory = this.factories.get(closureClass);
        if (factory != null) {
            // empty if block
        }
        return null;
    }

    synchronized <T> NativeClosureFactory<T> getClosureFactory(Class<T> closureClass) {
        NativeClosureFactory factory = this.factories.get(closureClass);
        if (factory != null) {
            return factory;
        }
        factory = NativeClosureFactory.newClosureFactory(this.runtime, closureClass, this.typeMapper);
        this.factories.put(closureClass, factory);
        return factory;
    }

    <T> ToNativeConverter<T, Pointer> newClosureSite(Class<T> closureClass) {
        return new ClosureSite(this.getClosureFactory(closureClass));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ClosureSite<T>
    implements ToNativeConverter<T, Pointer> {
        private final NativeClosureFactory<T> factory;
        private NativeClosureFactory.ClosureReference closureReference = null;

        private ClosureSite(NativeClosureFactory<T> factory) {
            this.factory = factory;
        }

        @Override
        public Pointer toNative(T value, ToNativeContext context) {
            NativeClosureFactory.ClosureReference ref = this.closureReference;
            if (ref != null && ref.getCallable() == value) {
                return ref.getPointer();
            }
            ref = this.factory.getClosureReference(value);
            if (this.closureReference == null || this.closureReference.get() == null) {
                this.closureReference = ref;
            }
            return ref.getPointer();
        }

        @Override
        public Class<Pointer> nativeType() {
            return Pointer.class;
        }
    }
}

