/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.dialogs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.ui.eclipse.serverconfig.Messages;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class AddAddressListElementDialog
extends Dialog {
    private Button radioSubnet;
    private Button radioRange;
    private LabeledText textAddr1;
    private LabeledText textAddr2;
    private InetAddress address1;
    private InetAddress address2;
    private int type;

    public AddAddressListElementDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.AddAddressListElementDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.radioSubnet = new Button(dialogArea, 16);
        Messages.get();
        this.radioSubnet.setText(Messages.AddAddressListElementDialog_Subnet);
        this.radioSubnet.setSelection(true);
        this.radioSubnet.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LabeledText labeledText = AddAddressListElementDialog.this.textAddr1;
                Messages.get();
                labeledText.setLabel(Messages.AddAddressListElementDialog_NetAddr);
                LabeledText labeledText2 = AddAddressListElementDialog.this.textAddr2;
                Messages.get();
                labeledText2.setLabel(Messages.AddAddressListElementDialog_NetMask);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.radioRange = new Button(dialogArea, 16);
        Messages.get();
        this.radioRange.setText(Messages.AddAddressListElementDialog_AddrRange);
        this.radioRange.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LabeledText labeledText = AddAddressListElementDialog.this.textAddr1;
                Messages.get();
                labeledText.setLabel(Messages.AddAddressListElementDialog_StartAddr);
                LabeledText labeledText2 = AddAddressListElementDialog.this.textAddr2;
                Messages.get();
                labeledText2.setLabel(Messages.AddAddressListElementDialog_EndAddr);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.textAddr1 = new LabeledText(dialogArea, 0);
        Messages.get();
        this.textAddr1.setLabel(Messages.AddAddressListElementDialog_NetAddr);
        this.textAddr1.setText("0.0.0.0");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.textAddr1.setLayoutData((Object)gd);
        this.textAddr2 = new LabeledText(dialogArea, 0);
        Messages.get();
        this.textAddr2.setLabel(Messages.AddAddressListElementDialog_NetMask);
        this.textAddr2.setText("255.255.255.0");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textAddr2.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.type = this.radioSubnet.getSelection() ? 0 : 1;
        try {
            this.address1 = InetAddress.getByName(this.textAddr1.getText());
            this.address2 = InetAddress.getByName(this.textAddr2.getText());
        }
        catch (UnknownHostException unknownHostException) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.AddAddressListElementDialog_Warning, (String)Messages.AddAddressListElementDialog_EnterValidData);
            return;
        }
        super.okPressed();
    }

    public InetAddress getAddress1() {
        return this.address1;
    }

    public InetAddress getAddress2() {
        return this.address2;
    }

    public int getType() {
        return this.type;
    }
}

