/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.util.Date;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.TimePeriod;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.DateTimeSelector;

public class TimePeriodSelector
extends Composite {
    private Button radioBackFromNow;
    private Button radioFixedInterval;
    private Spinner timeRange;
    private Combo timeUnits;
    private DateTimeSelector timeFrom;
    private DateTimeSelector timeTo;

    public TimePeriodSelector(Composite parent, int style, TimePeriod period) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        Group timeGroup = new Group(parent, 0);
        timeGroup.setText("Time Period");
        GridLayout layout = new GridLayout();
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        layout.horizontalSpacing = 16;
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 2;
        timeGroup.setLayout((Layout)layout);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TimePeriodSelector.this.timeRange.setEnabled(TimePeriodSelector.this.radioBackFromNow.getSelection());
                TimePeriodSelector.this.timeUnits.setEnabled(TimePeriodSelector.this.radioBackFromNow.getSelection());
                TimePeriodSelector.this.timeFrom.setEnabled(TimePeriodSelector.this.radioFixedInterval.getSelection());
                TimePeriodSelector.this.timeTo.setEnabled(TimePeriodSelector.this.radioFixedInterval.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.radioBackFromNow = new Button((Composite)timeGroup, 16);
        this.radioBackFromNow.setText("Back from now");
        this.radioBackFromNow.setSelection(period.getTimeFrameType() == 1);
        this.radioBackFromNow.addSelectionListener(listener);
        this.radioFixedInterval = new Button((Composite)timeGroup, 16);
        this.radioFixedInterval.setText("Fixed time frame");
        this.radioFixedInterval.setSelection(period.getTimeFrameType() == 0);
        this.radioFixedInterval.addSelectionListener(listener);
        Composite timeBackGroup = new Composite((Composite)timeGroup, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        timeBackGroup.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        timeBackGroup.setLayoutData((Object)gd);
        this.timeRange = WidgetHelper.createLabeledSpinner(timeBackGroup, 2048, "Time interval", 1, 10000, "WidgetHelper::default_layout_data");
        this.timeRange.setSelection(period.getTimeRangeValue());
        this.timeRange.setEnabled(this.radioBackFromNow.getSelection());
        this.timeUnits = WidgetHelper.createLabeledCombo(timeBackGroup, 8, "Time units", "WidgetHelper::default_layout_data");
        this.timeUnits.add("Minutes");
        this.timeUnits.add("Hours");
        this.timeUnits.add("Days");
        this.timeUnits.select(period.getTimeUnitValue());
        this.timeUnits.setEnabled(this.radioBackFromNow.getSelection());
        Composite timeFixedGroup = new Composite((Composite)timeGroup, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 4;
        timeFixedGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        timeFixedGroup.setLayoutData((Object)gd);
        WidgetFactory factory = new WidgetFactory(){

            @Override
            public Control createControl(Composite parent, int style) {
                return new DateTimeSelector(parent, style);
            }
        };
        this.timeFrom = (DateTimeSelector)WidgetHelper.createLabeledControl(timeFixedGroup, 0, factory, "Time from", "WidgetHelper::default_layout_data");
        this.timeFrom.setValue(period.getTimeFromValue());
        this.timeFrom.setEnabled(this.radioFixedInterval.getSelection());
        this.timeTo = (DateTimeSelector)WidgetHelper.createLabeledControl(timeFixedGroup, 0, factory, "Time to", "WidgetHelper::default_layout_data");
        this.timeTo.setValue(period.getTimeToValue());
        this.timeTo.setEnabled(this.radioFixedInterval.getSelection());
    }

    public TimePeriod getTimePeriod() {
        TimePeriod tp = new TimePeriod();
        tp.setTimeFrameType(this.radioBackFromNow.getSelection() ? 1 : 0);
        tp.setTimeRangeValue(this.timeRange.getSelection());
        tp.setTimeUnitValue(this.timeUnits.getSelectionIndex());
        tp.setTimeFromValue(this.timeFrom.getValue());
        tp.setTimeToValue(this.timeTo.getValue());
        return tp;
    }

    public int getTimeFrameType() {
        return this.radioBackFromNow.getSelection() ? 1 : 0;
    }

    public int getTimeRangeValue() {
        return this.timeRange.getSelection();
    }

    public int getTimeUnitValue() {
        return this.timeUnits.getSelectionIndex();
    }

    public Date getTimeFrom() {
        return this.timeFrom.getValue();
    }

    public Date getTimeTo() {
        return this.timeTo.getValue();
    }

    public void setDefaults() {
        this.radioBackFromNow.setSelection(true);
        this.radioFixedInterval.setSelection(false);
        this.timeRange.setSelection(60);
        this.timeRange.setEnabled(true);
        this.timeUnits.select(0);
        this.timeUnits.setEnabled(true);
        this.timeFrom.setEnabled(false);
        this.timeTo.setEnabled(false);
    }
}

