/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.netxms.base.NXCPMessage;

public class ServerFile {
    public static final int FILE = 1;
    public static final int DIRECTORY = 2;
    public static final int SYMBOLYC_LINK = 4;
    public static final int PLACEHOLDER = 65536;
    private String name;
    private long size;
    private Date modificationTime;
    private String extension;
    private int type = 0;
    private List<ServerFile> children;
    private ServerFile parent;
    private long nodeId;

    public ServerFile(NXCPMessage msg, long baseId) {
        this.name = msg.getFieldAsString(baseId);
        this.size = msg.getFieldAsInt64(baseId + 1L);
        this.modificationTime = msg.getFieldAsDate(baseId + 2L);
        this.setExtension();
    }

    public ServerFile(NXCPMessage msg, long baseId, ServerFile parent, long nodeId) {
        this.name = msg.getFieldAsString(baseId);
        this.size = msg.getFieldAsInt64(baseId + 1L);
        this.modificationTime = msg.getFieldAsDate(baseId + 2L);
        this.type = (int)msg.getFieldAsInt64(baseId + 3L);
        this.parent = parent;
        this.nodeId = nodeId;
        this.setExtension();
    }

    public ServerFile(String name, int fileType, ServerFile parent, long nodeId) {
        this.name = name;
        this.type = fileType;
        this.parent = parent;
        this.nodeId = nodeId;
        this.modificationTime = new Date();
        this.setExtension();
    }

    private void setExtension() {
        if (this.isDirectory() || this.name.startsWith(".")) {
            this.extension = " ";
            return;
        }
        String[] parts = this.name.split("\\.");
        this.extension = parts.length > 1 ? parts[parts.length - 1] : " ";
    }

    public boolean isDirectory() {
        return (this.type & 2) > 0;
    }

    public boolean isPlaceholder() {
        return (this.type & 0x10000) > 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.setExtension();
    }

    public long getSize() {
        return this.size;
    }

    public Date getModifyicationTime() {
        return this.modificationTime;
    }

    public String getExtension() {
        return this.extension;
    }

    public ServerFile[] getChildren() {
        if (this.children == null) {
            return null;
        }
        return this.children.toArray(new ServerFile[this.children.size()]);
    }

    public void setChildren(ServerFile[] children) {
        this.children = new ArrayList<ServerFile>(Arrays.asList(children));
    }

    public void removeChield(ServerFile chield) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).getName().equalsIgnoreCase(chield.getName())) continue;
            this.children.remove(i);
        }
    }

    public void addChield(ServerFile chield) {
        boolean childReplaced = false;
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).getName().equalsIgnoreCase(chield.getName())) continue;
            this.children.add(i, chield);
            childReplaced = true;
        }
        if (!childReplaced) {
            this.children.add(chield);
        }
    }

    public String getFullName() {
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.getFullName() + "/" + this.name;
    }

    public ServerFile getParent() {
        return this.parent;
    }

    public void setParent(ServerFile parent) {
        this.parent = parent;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public int getType() {
        return this.type;
    }
}

