/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxBblob;
import com.informix.jdbc.IfxCblob;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxTmpFile;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.memoryUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import netscape.security.PrivilegeManager;

public class IfxBlob
extends IfxObject {
    private static final short h = 0;
    private static final short i = 1;
    private static final short j = 2;
    private static final short k = 3;
    protected static final short BLOBISNULL = 1;
    protected static final short BLOB_TYPE_BYTES = 0;
    protected static final short BLOB_TYPE_STREAM = 1;
    protected byte[] blobDesc = null;
    protected int tb_start = 1;
    protected int tb_end = 0;
    protected int tb_size;
    protected short tb_flags;
    protected InputStream BlobInputStream;
    protected IfxTmpFile tempBlobFile = null;
    protected byte[] blobBuffer;
    protected short blobType;
    protected boolean isBlob_loaded = false;
    protected short ifxType = 0;

    IfxBlob() throws SQLException {
        this.blobDesc = new byte[56];
        this.nullify();
    }

    public IfxBlob(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
    }

    public IfxBlob(byte[] byArray) throws SQLException {
        this.fromBytes(byArray);
    }

    protected short getBlobType() {
        return this.blobType;
    }

    protected boolean isBlobByteType() {
        return this.blobType == 0;
    }

    protected boolean isIfxTextType() {
        return this.ifxType == 1;
    }

    protected byte[] getBlobBuffer() {
        return this.blobBuffer;
    }

    protected void setBlobBuffer(byte[] byArray) {
        this.blobBuffer = byArray;
    }

    protected int getBlobLength() {
        return this.tb_end - this.tb_start + 1;
    }

    protected void setBlobLength(int n, int n2, int n3) {
        this.tb_size = n;
        this.tb_start = n2;
        this.tb_end = n3;
    }

    protected void setBlobLength(int n) {
        this.setBlobLength(n, 1, n);
    }

    protected InputStream getBlobInputStream() {
        return this.BlobInputStream;
    }

    protected String getBlobFileName() {
        if (this.tempBlobFile != null) {
            return this.tempBlobFile.getFileName();
        }
        return null;
    }

    protected void setBlobFileName() {
        if (this.tempBlobFile != null) {
            this.tempBlobFile.close();
            this.tempBlobFile = null;
        }
    }

    protected boolean isBlobLoaded() {
        return this.isBlob_loaded;
    }

    protected void setLoaded() {
        this.isBlob_loaded = true;
    }

    public void fromIfx(byte[] byArray) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length);
    }

    public void fromIfx(byte[] byArray, int n, int n2) throws SQLException {
        if (this.blobDesc == null) {
            this.blobDesc = new byte[56];
        }
        System.arraycopy(byArray, n, this.blobDesc, 0, 56);
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[4];
        byte[] byArray5 = new byte[2];
        System.arraycopy(byArray, 16 + n, byArray2, 0, 4);
        System.arraycopy(byArray, 8 + n, byArray3, 0, 4);
        System.arraycopy(byArray, 12 + n, byArray4, 0, 4);
        this.setBlobLength(IfxToJavaType.IfxToJavaInt(byArray2), IfxToJavaType.IfxToJavaInt(byArray3), IfxToJavaType.IfxToJavaInt(byArray4));
        boolean bl = this.conn.isXPS();
        if (bl) {
            this.tb_size = this.tb_end - this.tb_start + 1;
        }
        System.arraycopy(byArray, 38 + n, byArray5, 0, 2);
        this.tb_flags = IfxToJavaType.IfxToJavaSmallInt(byArray5);
        if (this.tb_flags != 1) {
            this.isBlob_loaded = false;
            this.blobType = 0;
            this.unnullify();
        }
    }

    public byte[] toIfx() {
        byte[] byArray = new byte[4];
        byArray = JavaToIfxType.JavaToIfxInt(this.tb_size);
        if (this.blobDesc == null) {
            this.blobDesc = new byte[56];
        }
        System.arraycopy(byArray, 0, this.blobDesc, 16, 4);
        return this.blobDesc;
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            if (this.blobDesc == null) {
                this.blobDesc = new byte[56];
            }
            memoryUtil.byfill(this.blobDesc, (byte)0);
            this.blobDesc[39] = 1;
            return this.blobDesc;
        }
        return this.toIfx();
    }

    public InputStream toAsciiStream() throws SQLException {
        if (this.tempBlobFile != null) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                IfxInputStream ifxInputStream = this.tempBlobFile.b();
                return ifxInputStream;
            }
            catch (Exception exception) {
                SQLException sQLException = IfxErrMsg.getSQLException(-79701, exception.toString(), this.conn);
                sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
                throw sQLException;
            }
        }
        if (this.blobBuffer != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.blobBuffer);
            return byteArrayInputStream;
        }
        return null;
    }

    public void fromInputStream(InputStream inputStream, int n) throws SQLException {
        block3: {
            block2: {
                this.setBlobLength(n);
                if (!(inputStream instanceof IfxLobInputStream)) break block2;
                this.BlobInputStream = ((IfxLobInputStream)inputStream).getStream();
                if (IfxStatement.t == 0) break block3;
            }
            this.BlobInputStream = inputStream;
        }
        this.isBlob_loaded = false;
        this.blobType = 1;
        this.blobBuffer = null;
        this.unnullify();
    }

    /*
     * Unable to fully structure code
     */
    public void fromCharacterStream(Reader var1_1, int var2_2) throws SQLException {
        if (var2_2 > 0 && var1_1 != null) {
            var3_3 = new char[var2_2];
            var4_4 = 0;
            var5_5 = 0;
            var6_6 = new BufferedReader(var1_1);
            try {
                if (var6_6.ready()) {
                    var4_4 = var6_6.read(var3_3, var5_5, var2_2);
                    this.setBlobLength(var4_4);
                    this.blobBuffer = new String(var3_3).getBytes();
                    if (IfxStatement.t == 0) ** GOTO lbl21
                }
                this.setBlobLength(0);
                this.blobBuffer = null;
            }
            catch (Exception var7_7) {
                var8_8 = IfxErrMsg.getSQLException(-79716, var7_7.toString(), this.conn);
                var8_8 = IfxErrMsg.setSQLExceptionCause(var8_8, var7_7);
                throw var8_8;
            }
        } else {
            this.setBlobLength(0);
            this.blobBuffer = null;
        }
lbl21:
        // 3 sources

        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
        this.unnullify();
    }

    public Reader toCharacterStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new StringReader(this.toString());
    }

    public void fromAsciiStream(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
        this.ifxType = 1;
    }

    public InputStream toBinaryStream() throws SQLException {
        return this.toAsciiStream();
    }

    public void fromBinaryStream(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
        this.ifxType = 0;
    }

    public String toString() {
        int n = IfxStatement.t;
        if (this.blobBuffer != null) {
            return new String(this.blobBuffer);
        }
        if (this.tempBlobFile != null) {
            byte[] byArray;
            block11: {
                int n2;
                IfxInputStream ifxInputStream;
                if (System.getProperty("java.vendor").startsWith("Netscape")) {
                    try {
                        PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    ifxInputStream = this.tempBlobFile.b();
                    n2 = ifxInputStream.available();
                }
                catch (Exception exception) {
                    return null;
                }
                IfxInputStream ifxInputStream2 = ifxInputStream;
                byArray = new byte[n2];
                int n3 = 0;
                try {
                    byte by = (byte)((InputStream)ifxInputStream2).read();
                    while (by != -1) {
                        byArray[n3] = by;
                        ++n3;
                        by = (byte)((InputStream)ifxInputStream2).read();
                        if (n == 0) {
                            if (n == 0) continue;
                        }
                        break block11;
                    }
                    ((FileInputStream)ifxInputStream).close();
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return new String(byArray);
        }
        return null;
    }

    public void fromString(String string) throws SQLException {
        block3: {
            block2: {
                if (string != null) break block2;
                this.setBlobLength(0);
                this.blobBuffer = null;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.setBlobLength(string.length());
            this.blobBuffer = string.getBytes();
            this.unnullify();
        }
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
    }

    public Object toObject() throws SQLException {
        return this.toBytes();
    }

    public byte[] toBytes() throws SQLException {
        if (this.blobBuffer != null) {
            return (byte[])this.blobBuffer.clone();
        }
        if (this.tempBlobFile != null) {
            int n;
            IfxInputStream ifxInputStream;
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                ifxInputStream = this.tempBlobFile.b();
                n = ifxInputStream.available();
            }
            catch (Exception exception) {
                return null;
            }
            byte[] byArray = new byte[n];
            try {
                ifxInputStream.read(byArray, 0, n);
                ((FileInputStream)ifxInputStream).close();
            }
            catch (Exception exception) {
                return null;
            }
            return byArray;
        }
        return null;
    }

    public void fromBytes(byte[] byArray) {
        block3: {
            block2: {
                if (byArray != null) break block2;
                this.setBlobLength(0);
                this.blobBuffer = null;
                if (IfxStatement.t == 0) break block3;
            }
            this.setBlobLength(byArray.length);
            this.blobBuffer = byArray;
            this.unnullify();
        }
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
    }

    public Blob toBlob() throws SQLException {
        IfxBblob ifxBblob = null;
        if (this.tempBlobFile != null) {
            try {
                ifxBblob = new IfxBblob(this.tempBlobFile);
            }
            catch (Exception exception) {
                return null;
            }
        } else if (this.blobBuffer != null) {
            ifxBblob = new IfxBblob(this.blobBuffer);
        } else {
            return null;
        }
        ifxBblob.setLoadFlag();
        ifxBblob.setIfxLobType((short)0);
        ifxBblob.setSize(this.getBlobLength());
        return ifxBblob;
    }

    public Clob toClob() throws SQLException {
        IfxCblob ifxCblob = null;
        if (this.tempBlobFile != null) {
            try {
                ifxCblob = new IfxCblob(this.tempBlobFile);
            }
            catch (Exception exception) {
                return null;
            }
        } else if (this.blobBuffer != null) {
            ifxCblob = new IfxCblob((Connection)this.conn, this.blobBuffer);
        } else {
            return null;
        }
        ifxCblob.setLoadFlag();
        ifxCblob.setIfxLobType((short)1);
        ifxCblob.setSize(this.getBlobLength());
        return ifxCblob;
    }

    public void fromBlob(Blob blob) {
        IfxBblob ifxBblob = (IfxBblob)blob;
        short s = ifxBblob.getIfxLobType();
        if (s == 2 || s == 0) {
            try {
                this.fromBinaryStream(ifxBblob.getStreamImd(), (int)blob.length());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void fromClob(Clob clob) {
        IfxCblob ifxCblob = (IfxCblob)clob;
        short s = ifxCblob.getIfxLobType();
        if (s == 3 || s == 1) {
            try {
                this.fromAsciiStream(ifxCblob.getStreamImd(), (int)clob.length());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void clear() {
        this.isBlob_loaded = false;
        this.ifxType = 0;
        if (this.tempBlobFile != null) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.tempBlobFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.blobBuffer = null;
        this.tempBlobFile = null;
        super.clear();
    }

    void g() {
    }

    protected void finalize() {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

