/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxBaseType;
import com.informix.jdbc.IfxBblob;
import com.informix.jdbc.IfxByteArrayInputStream;
import com.informix.jdbc.IfxCblob;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxLob;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxOutputStream;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxTmpFile;
import com.informix.util.IfxErrMsg;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import netscape.security.PrivilegeManager;

public class IfxSmBlob
extends IfxBaseType {
    private static final short h = 0;
    private static final short i = 1;
    private static final short j = 2;
    private static final short k = 3;
    protected static final short BLOB_BUFFER_SIZE = 1024;
    protected static final short LO_READ = 0;
    protected static final short LO_READWITHSEEK = 1;
    protected static final short LO_WRITE = 2;
    protected static final short R_W_BUFSIZE = 32000;
    protected static final short FILE_OPEN = 0;
    protected static final short FILE_CLOSE = 1;
    protected static final short FILE_READ = 2;
    protected static final short FILE_WRITE = 3;
    protected static final int LO_O_EXCL = 1;
    protected static final int LO_O_APPEND = 2;
    protected static final int LO_O_TRUNC = 4;
    protected static final int LO_O_RDWR = 8;
    protected static final int LO_O_RDONLY = 16;
    protected static final int LO_O_WRONLY = 32;
    protected static final int LO_O_BINARY = 64;
    protected static final int LO_O_TEXT = 128;
    protected static final short EIO = 5;
    protected static final short ENOENT = 2;
    protected static final short EBADF = 9;
    protected static final short EACCES = 13;
    protected static final short EEXIST = 17;
    protected static final short ESPIPE = 29;
    protected static final short BLOB_TYPE_BYTES = 1;
    protected static final short BLOB_TYPE_STREAM = 2;
    protected static final short BLOB_TYPE_CHARSTREAM = 3;
    protected boolean LOB_ELEMENT_COLL = false;
    protected IfxLocator locator = null;
    protected int loFd = -1;
    protected long sm_size;
    protected InputStream BlobInputStream;
    protected Reader BlobCharInputStream;
    protected IfxTmpFile tempBlobFile = null;
    protected byte[] blobBuffer;
    protected short blobType;
    protected boolean isBlob_loaded = false;
    protected short IfxSmBlobType = (short)2;
    protected String tableName = null;
    protected String columnName = null;

    public IfxSmBlob() throws SQLException {
    }

    public IfxSmBlob(IfxConnection ifxConnection, IfxLocator ifxLocator) throws SQLException {
        this.conn = ifxConnection;
        this.locator = ifxLocator;
        this.isBlob_loaded = false;
        this.blobType = 0;
        this.unnullify();
    }

    public IfxSmBlob(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
    }

    public IfxSmBlob(byte[] byArray) throws SQLException {
        this.fromBytes(byArray);
    }

    public IfxSmBlob(Blob blob) throws SQLException {
        this.fromBlob(blob);
        this.IfxSmBlobType = (short)2;
    }

    public IfxSmBlob(Clob clob) throws SQLException {
        this.fromClob(clob);
        this.IfxSmBlobType = (short)3;
    }

    public void setTableName(String string) {
        block3: {
            block2: {
                if (string == null || string.indexOf(40) <= 0) break block2;
                this.tableName = string.substring(0, string.indexOf(40));
                if (IfxStatement.t == 0) break block3;
            }
            this.tableName = string;
        }
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    private void g() {
        try {
            IfxSmartBlob ifxSmartBlob = new IfxSmartBlob(this.conn);
            this.loFd = ifxSmartBlob.IfxLoOpen(this.locator, 16);
            this.sm_size = ifxSmartBlob.IfxLoSize(this.loFd);
            ifxSmartBlob.IfxLoClose(this.loFd);
            ifxSmartBlob = null;
        }
        catch (Exception exception) {
            this.sm_size = 0L;
        }
    }

    public void fromIfx(byte[] byArray) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length);
    }

    public void fromIfx(byte[] byArray, int n, int n2) throws SQLException {
        block3: {
            block2: {
                super.fromIfx(byArray, n, n2);
                if (this.isNull()) break block2;
                byte[] byArray2 = this.inputStream.a();
                this.locator = new IfxLocator(byArray2, this.conn);
                this.isBlob_loaded = false;
                this.blobType = 0;
                this.unnullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.locator = null;
            this.nullify();
        }
    }

    protected void fromIfxFP(byte[] byArray) throws SQLException {
        block3: {
            block2: {
                super.fromIfx(byArray);
                if (this.isNull()) break block2;
                byte[] byArray2 = this.inputStream.a();
                this.locator = new IfxLocator(byArray2, this.conn);
                if (IfxStatement.t == 0) break block3;
            }
            this.locator = null;
            this.nullify();
        }
    }

    public byte[] toIfx() throws SQLException {
        this.outputStream.a();
        if (!this.isNull()) {
            this.outputStream.writeBytes(this.locator.a());
        }
        return super.toIfx();
    }

    public byte[] toIfxTuple() throws SQLException {
        this.outputStream.a();
        if (!this.isNull()) {
            this.outputStream.writeBytes(this.locator.a());
        }
        return super.toIfxTuple();
    }

    public InputStream toAsciiStream() throws SQLException {
        if (!this.isBlob_loaded) {
            try {
                IfxLobInputStream ifxLobInputStream = new IfxLobInputStream(this.conn, this.locator);
                return ifxLobInputStream;
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        if (this.tempBlobFile != null) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                IfxInputStream ifxInputStream = this.tempBlobFile.b();
                return ifxInputStream;
            }
            catch (Exception exception) {
                SQLException sQLException = IfxErrMsg.getSQLException(-79701, exception.toString(), this.conn);
                sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
                throw sQLException;
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.blobBuffer);
        return byteArrayInputStream;
    }

    public void fromInputStream(InputStream inputStream, int n) throws SQLException {
        this.sm_size = n;
        this.BlobInputStream = inputStream;
        this.isBlob_loaded = false;
        this.blobType = (short)2;
        this.blobBuffer = null;
        this.locator = new IfxLocator(this.conn);
        if (((IfxSqliConnect)this.conn).usePut || this.LOB_ELEMENT_COLL) {
            this.a(inputStream, n);
        }
    }

    void a(Reader reader, int n) throws SQLException {
        this.unnullify();
        IfxSmartBlob ifxSmartBlob = null;
        InputStream inputStream = null;
        try {
            ifxSmartBlob = this.i();
            if (n > 0) {
                try {
                    Object object;
                    if (((IfxSqliConnect)this.conn).x() && this.d(n) || ((IfxSqliConnect)this.conn).getBlobCacheSize() < n) {
                        object = this.h();
                        inputStream = this.a(reader, (IfxTmpFile)object, n);
                        n = ((IfxTmpFile)object).a();
                        this.sm_size = n;
                    } else {
                        object = this.e(n);
                        inputStream = this.a(reader, (ByteArrayOutputStream)object, n);
                        n = this.a((ByteArrayOutputStream)object);
                        this.sm_size = n;
                    }
                }
                catch (Exception exception) {
                    SQLException sQLException = IfxErrMsg.getSQLException(-79716, exception.toString(), (String)null);
                    sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
                    throw sQLException;
                }
                int n2 = 0;
                if (inputStream != null ? (n2 = ifxSmartBlob.IfxLoWrite(this.loFd, inputStream, n)) != n : (n2 = ifxSmartBlob.IfxLoWrite(this.loFd, this.blobBuffer)) != (this.blobBuffer == null ? 0 : this.blobBuffer.length)) {
                    throw IfxErrMsg.getSQLException(-79754, this.conn);
                }
            }
            ifxSmartBlob.IfxLoClose(this.loFd);
        }
        catch (SQLException sQLException) {
            if (ifxSmartBlob != null) {
                ifxSmartBlob.IfxLoClose(this.loFd);
            }
            this.sm_size = 0L;
            this.nullify();
            throw sQLException;
        }
    }

    void a(InputStream inputStream, int n) throws SQLException {
        this.unnullify();
        IfxSmartBlob ifxSmartBlob = null;
        try {
            ifxSmartBlob = this.i();
            if (n > 0) {
                block10: {
                    if (this.extendedID == 11 && ((IfxSqliConnect)this.conn).x()) {
                        try {
                            Object object;
                            if (this.d(n)) {
                                object = this.h();
                                inputStream = this.a(inputStream, (IfxTmpFile)object, n);
                                n = ((IfxTmpFile)object).a();
                                this.sm_size = n;
                                if (IfxStatement.t == 0) break block10;
                            }
                            object = this.e(n);
                            inputStream = this.a(inputStream, (ByteArrayOutputStream)object, n);
                            n = this.a((ByteArrayOutputStream)object);
                            this.sm_size = n;
                        }
                        catch (Exception exception) {
                            SQLException sQLException = IfxErrMsg.getSQLException(-79716, exception.toString(), (String)null);
                            sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
                            throw sQLException;
                        }
                    }
                }
                int n2 = 0;
                if (inputStream != null ? (n2 = ifxSmartBlob.IfxLoWrite(this.loFd, inputStream, n)) != n : (n2 = ifxSmartBlob.IfxLoWrite(this.loFd, this.blobBuffer)) != (this.blobBuffer == null ? 0 : this.blobBuffer.length)) {
                    throw IfxErrMsg.getSQLException(-79754, this.conn);
                }
            }
            ifxSmartBlob.IfxLoClose(this.loFd);
        }
        catch (SQLException sQLException) {
            if (ifxSmartBlob != null) {
                ifxSmartBlob.IfxLoClose(this.loFd);
            }
            this.sm_size = 0L;
            this.nullify();
            throw sQLException;
        }
    }

    private void a(Reader reader, OutputStream outputStream, String string) throws Exception {
        block2: {
            int n;
            int n2 = IfxStatement.t;
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string));
            char[] cArray = new char[4096];
            while ((n = reader.read(cArray)) != -1) {
                ((Writer)bufferedWriter).write(cArray, 0, n);
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block2;
            }
            reader.close();
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
            outputStream.close();
        }
    }

    private InputStream a(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, int n) throws Exception {
        String string = ((IfxSqliConnect)this.conn).getclEncoding();
        String string2 = ((IfxSqliConnect)this.conn).getdbEncoding();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        this.a((Reader)bufferedReader, (OutputStream)byteArrayOutputStream, string2);
        return new IfxByteArrayInputStream(byteArrayOutputStream);
    }

    private InputStream a(InputStream inputStream, IfxTmpFile ifxTmpFile, int n) throws Exception {
        String string = ((IfxSqliConnect)this.conn).getclEncoding();
        String string2 = ((IfxSqliConnect)this.conn).getdbEncoding();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        IfxOutputStream ifxOutputStream = null;
        ifxOutputStream = ifxTmpFile.c();
        this.a((Reader)bufferedReader, ifxOutputStream, string2);
        return ifxTmpFile.b();
    }

    private InputStream a(Reader reader, ByteArrayOutputStream byteArrayOutputStream, int n) throws Exception {
        String string = ((IfxSqliConnect)this.conn).getdbEncoding();
        this.a(reader, (OutputStream)byteArrayOutputStream, string);
        return new IfxByteArrayInputStream(byteArrayOutputStream);
    }

    private InputStream a(Reader reader, IfxTmpFile ifxTmpFile, int n) throws Exception {
        String string = ((IfxSqliConnect)this.conn).getdbEncoding();
        IfxOutputStream ifxOutputStream = null;
        ifxOutputStream = ifxTmpFile.c();
        this.a(reader, ifxOutputStream, string);
        return ifxTmpFile.b();
    }

    private int a(ByteArrayOutputStream byteArrayOutputStream) throws SQLException {
        return byteArrayOutputStream.size();
    }

    private boolean d(int n) {
        return n > ((IfxSqliConnect)this.conn).u();
    }

    private ByteArrayOutputStream e(int n) {
        return new ByteArrayOutputStream(n);
    }

    private IfxTmpFile h() throws Exception {
        this.tempBlobFile = new IfxTmpFile(this.conn);
        return this.tempBlobFile;
    }

    private IfxSmartBlob i() throws SQLException {
        IfxSmartBlob ifxSmartBlob = null;
        ifxSmartBlob = new IfxSmartBlob(this.conn);
        IfxLobDescriptor ifxLobDescriptor = null;
        ifxLobDescriptor = this.tableName == null || this.columnName == null ? new IfxLobDescriptor(this.conn) : ifxSmartBlob.IfxLoColInfo(this.tableName + "." + this.columnName);
        this.loFd = ifxSmartBlob.IfxLoCreate(ifxLobDescriptor, 8, this.locator);
        return ifxSmartBlob;
    }

    public void fromCharacterStream(Reader reader, int n) throws SQLException {
        this.sm_size = n;
        this.BlobCharInputStream = reader;
        this.isBlob_loaded = false;
        this.blobType = (short)3;
        this.blobBuffer = null;
        this.BlobInputStream = null;
        this.locator = new IfxLocator(this.conn);
        if (((IfxSqliConnect)this.conn).usePut || this.LOB_ELEMENT_COLL) {
            this.a(reader, n);
        }
        this.IfxSmBlobType = (short)3;
    }

    public void fromAsciiStream(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
        this.IfxSmBlobType = (short)3;
    }

    public InputStream toBinaryStream() throws SQLException {
        return this.toAsciiStream();
    }

    public void fromBinaryStream(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
        this.IfxSmBlobType = (short)2;
    }

    public String toString() {
        try {
            IfxCblob ifxCblob = new IfxCblob(this.conn, this.locator);
            ifxCblob.setSize(this.sm_size);
            return ifxCblob.getSubString(1L, (int)this.sm_size);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void fromString(String string) throws SQLException {
        block7: {
            if (string == null) {
                this.sm_size = 0L;
                this.blobBuffer = null;
                this.nullify();
                return;
            }
            this.sm_size = string.length();
            try {
                String string2 = this.conn.getdbEncoding();
                if (string2 != null) {
                    this.blobBuffer = string.getBytes(string2);
                    if (IfxStatement.t == 0) break block7;
                }
                this.blobBuffer = string.getBytes();
            }
            catch (IOException iOException) {
                SQLException sQLException = IfxErrMsg.getSQLException(-79783, iOException.toString(), this.conn);
                sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, iOException);
                throw sQLException;
            }
        }
        boolean bl = false;
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 1;
        this.unnullify();
        try {
            this.locator = new IfxLocator(this.conn);
        }
        catch (SQLException sQLException) {
            this.sm_size = 0L;
            this.nullify();
            throw sQLException;
        }
    }

    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        if (this.extendedID == 10) {
            return this.toBlob();
        }
        return this.toClob();
    }

    public void fromObject(Object object) throws SQLException {
        block5: {
            block8: {
                int n;
                block7: {
                    block6: {
                        block4: {
                            n = IfxStatement.t;
                            if (object == null) {
                                return;
                            }
                            if (!(object instanceof String)) break block4;
                            this.fromString((String)object);
                            if (n == 0) break block5;
                        }
                        if (!(object instanceof byte[])) break block6;
                        this.fromBytes((byte[])object);
                        if (n == 0) break block5;
                    }
                    if (!(object instanceof Blob)) break block7;
                    this.fromBlob((Blob)object);
                    if (n == 0) break block5;
                }
                if (!(object instanceof Clob)) break block8;
                this.fromClob((Clob)object);
                if (n == 0) break block5;
            }
            throw IfxErrMsg.getSQLException(-79791, this.conn);
        }
    }

    public byte[] toBytes() throws SQLException {
        this.g();
        IfxBblob ifxBblob = new IfxBblob(this.conn, this.locator);
        ifxBblob.setSize(this.sm_size);
        byte[] byArray = ifxBblob.getPortion(1L, this.sm_size);
        ifxBblob.close();
        return byArray;
    }

    public void fromBytes(byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.sm_size = 0L;
            this.blobBuffer = null;
            this.nullify();
            return;
        }
        this.sm_size = byArray.length;
        this.blobBuffer = byArray;
        this.unnullify();
        boolean bl = false;
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 1;
        try {
            this.locator = new IfxLocator(this.conn);
        }
        catch (SQLException sQLException) {
            this.sm_size = 0L;
            this.nullify();
            throw sQLException;
        }
    }

    public Blob toBlob() throws SQLException {
        this.g();
        IfxBblob ifxBblob = null;
        if (this.isBlob_loaded) {
            if (this.tempBlobFile != null) {
                try {
                    ifxBblob = new IfxBblob(this.tempBlobFile);
                }
                catch (Exception exception) {
                    SQLException sQLException = IfxErrMsg.getSQLException(-79701, exception.toString(), this.conn);
                    sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
                    throw sQLException;
                }
            } else if (this.blobBuffer != null) {
                ifxBblob = new IfxBblob(this.blobBuffer);
            }
        } else {
            ifxBblob = new IfxBblob(this.conn, this.locator);
        }
        ifxBblob.setIfxLobType((short)2);
        ifxBblob.setSize(this.sm_size);
        return ifxBblob;
    }

    public Clob toClob() throws SQLException {
        return this.toClob(8);
    }

    public Clob toClob(int n) throws SQLException {
        this.g();
        IfxLob ifxLob = null;
        if (this.isBlob_loaded) {
            if (this.tempBlobFile != null) {
                try {
                    ifxLob = new IfxCblob(this.tempBlobFile);
                }
                catch (Exception exception) {
                    SQLException sQLException = IfxErrMsg.getSQLException(-79701, exception.toString(), this.conn);
                    sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
                    throw sQLException;
                }
            } else if (this.blobBuffer != null) {
                ifxLob = new IfxCblob(this.blobBuffer);
            }
        } else {
            ifxLob = new IfxCblob(this.conn, this.locator, n);
        }
        ifxLob.setIfxLobType((short)3);
        ifxLob.setSize(this.sm_size);
        return ifxLob;
    }

    public void fromBlob(Blob blob) throws SQLException {
        block9: {
            block7: {
                short s;
                IfxBblob ifxBblob;
                block8: {
                    if (!(blob instanceof IfxBblob)) break block7;
                    ifxBblob = (IfxBblob)blob;
                    s = ifxBblob.getIfxLobType();
                    if (s != 2) break block8;
                    this.locator = ifxBblob.getLocator();
                    if (IfxStatement.t == 0) break block9;
                }
                if (s == 0) {
                    this.fromBinaryStream(ifxBblob.getBinaryStream(), (int)ifxBblob.length());
                }
                break block9;
            }
            this.fromBinaryStream(blob.getBinaryStream(), (int)blob.length());
        }
        this.unnullify();
    }

    public void fromClob(Clob clob) throws SQLException {
        block9: {
            block7: {
                short s;
                IfxCblob ifxCblob;
                block8: {
                    if (!(clob instanceof IfxCblob)) break block7;
                    ifxCblob = (IfxCblob)clob;
                    s = ifxCblob.getIfxLobType();
                    if (s != 3) break block8;
                    this.locator = ifxCblob.getLocator();
                    if (IfxStatement.t == 0) break block9;
                }
                if (s == 1) {
                    this.fromAsciiStream(ifxCblob.getAsciiStream(), (int)ifxCblob.length());
                }
                break block9;
            }
            this.fromAsciiStream(clob.getAsciiStream(), (int)clob.length());
        }
        this.unnullify();
    }

    public void clear() {
        this.nullify();
        this.isBlob_loaded = false;
        this.IfxSmBlobType = (short)2;
        this.blobBuffer = null;
        this.locator = null;
        if (this.tempBlobFile != null) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.tempBlobFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tempBlobFile = null;
    }

    protected void finalize() {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

