/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.AsynchronousFilllListener;
import net.sf.jasperreports.engine.fill.FillHandle;
import net.sf.jasperreports.engine.fill.FillListener;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFiller;

public abstract class BaseFillHandle
implements FillHandle {
    protected final JasperReportsContext jasperReportsContext;
    protected final JasperReport jasperReport;
    protected final Map<String, Object> parameters;
    protected final JRDataSource dataSource;
    protected final Connection conn;
    protected final JRBaseFiller filler;
    protected final List<AsynchronousFilllListener> listeners;
    protected boolean started;
    protected boolean running;
    protected boolean cancelled;
    protected final Object lock;

    protected BaseFillHandle(JasperReportsContext jasperReportsContext, JasperReport jasperReport, Map<String, Object> parameters, JRDataSource dataSource, Connection conn) throws JRException {
        this.jasperReportsContext = jasperReportsContext;
        this.jasperReport = jasperReport;
        this.parameters = parameters;
        this.dataSource = dataSource;
        this.conn = conn;
        this.filler = JRFiller.createFiller(jasperReportsContext, jasperReport);
        this.listeners = new ArrayList<AsynchronousFilllListener>();
        this.lock = this;
    }

    @Override
    public void addListener(AsynchronousFilllListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void addFillListener(FillListener listener) {
        this.filler.addFillListener(listener);
    }

    @Override
    public boolean removeListener(AsynchronousFilllListener listener) {
        return this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startFill() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                throw new IllegalStateException("Fill already started.");
            }
            this.started = true;
        }
        ReportFiller reportFiller = new ReportFiller();
        Executor executor = this.getReportExecutor();
        executor.execute(reportFiller);
    }

    protected abstract Executor getReportExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancellFill() throws JRException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.running) {
                throw new IllegalStateException("Fill not running.");
            }
            this.filler.cancelFill();
            this.cancelled = true;
        }
    }

    protected void notifyFinish(JasperPrint print) {
        for (AsynchronousFilllListener listener : this.listeners) {
            listener.reportFinished(print);
        }
    }

    protected void notifyCancel() {
        for (AsynchronousFilllListener listener : this.listeners) {
            listener.reportCancelled();
        }
    }

    protected void notifyError(Throwable e) {
        for (AsynchronousFilllListener listener : this.listeners) {
            listener.reportFillError(e);
        }
    }

    @Override
    public boolean isPageFinal(int pageIdx) {
        return this.filler.isPageFinal(pageIdx);
    }

    protected class ReportFiller
    implements Runnable {
        protected ReportFiller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object print;
            Object object = BaseFillHandle.this.lock;
            synchronized (object) {
                BaseFillHandle.this.running = true;
            }
            try {
                print = BaseFillHandle.this.conn != null ? BaseFillHandle.this.filler.fill(BaseFillHandle.this.parameters, BaseFillHandle.this.conn) : (BaseFillHandle.this.dataSource != null ? BaseFillHandle.this.filler.fill(BaseFillHandle.this.parameters, BaseFillHandle.this.dataSource) : BaseFillHandle.this.filler.fill(BaseFillHandle.this.parameters));
                BaseFillHandle.this.notifyFinish((JasperPrint)print);
            }
            catch (Throwable e) {
                Object object2 = BaseFillHandle.this.lock;
                synchronized (object2) {
                    if (BaseFillHandle.this.cancelled) {
                        BaseFillHandle.this.notifyCancel();
                    } else {
                        BaseFillHandle.this.notifyError(e);
                    }
                }
            }
            finally {
                print = BaseFillHandle.this.lock;
                synchronized (print) {
                    BaseFillHandle.this.running = false;
                }
            }
        }
    }
}

