/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.fill.JRTemplateGraphicElement;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.util.ObjectUtils;

public class JRTemplateLine
extends JRTemplateGraphicElement {
    private static final long serialVersionUID = 10200L;
    protected LineDirectionEnum directionValue = LineDirectionEnum.TOP_DOWN;
    private int PSEUDO_SERIAL_VERSION_UID = 50502;
    private byte direction;

    protected JRTemplateLine(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider, JRLine line) {
        super(origin, defaultStyleProvider);
        this.setLine(line);
    }

    public JRTemplateLine(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider) {
        super(origin, defaultStyleProvider);
        this.linePen = new JRBasePen(this);
    }

    protected void setLine(JRLine line) {
        super.setGraphicElement(line);
        this.setDirection(line.getDirectionValue());
    }

    public LineDirectionEnum getDirectionValue() {
        return this.directionValue;
    }

    public void setDirection(LineDirectionEnum directionValue) {
        this.directionValue = directionValue;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.directionValue = LineDirectionEnum.getByValue(this.direction);
        }
    }

    @Override
    public int getHashCode() {
        ObjectUtils.HashCode hash = ObjectUtils.hash();
        this.addGraphicHash(hash);
        hash.add(this.directionValue);
        return hash.getHashCode();
    }

    @Override
    public boolean isIdentical(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JRTemplateLine)) {
            return false;
        }
        JRTemplateLine template = (JRTemplateLine)object;
        return this.graphicIdentical(template) && ObjectUtils.equals(this.directionValue, template.directionValue);
    }
}

