/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import java.text.ParseException;
import java.util.List;
import org.hamcrest.Matcher;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.MatcherAssertionErrors;

public class JsonPathExpectationsHelper {
    private final String expression;
    private final JsonPath jsonPath;

    public JsonPathExpectationsHelper(String expression, Object ... args) {
        this.expression = String.format(expression, args);
        this.jsonPath = JsonPath.compile((String)this.expression, (Filter[])new Filter[0]);
    }

    public <T> void assertValue(String content, Matcher<T> matcher) throws ParseException {
        Object value = this.evaluateJsonPath(content);
        MatcherAssertionErrors.assertThat("JSON path" + this.expression, value, matcher);
    }

    private Object evaluateJsonPath(String content) throws ParseException {
        String message = "No value for JSON path: " + this.expression + ", exception: ";
        try {
            return this.jsonPath.read(content);
        }
        catch (InvalidPathException ex) {
            throw new AssertionError((Object)(message + ex.getMessage()));
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new AssertionError((Object)(message + ex.getMessage()));
        }
        catch (IndexOutOfBoundsException ex) {
            throw new AssertionError((Object)(message + ex.getMessage()));
        }
    }

    public void assertValue(String responseContent, Object expectedValue) throws ParseException {
        Object actualValue = this.evaluateJsonPath(responseContent);
        if (actualValue instanceof List && !(expectedValue instanceof List)) {
            List actualValueList = (List)actualValue;
            if (actualValueList.size() == 0) {
                AssertionErrors.fail("No matching value for JSON path \"" + this.expression + "\"");
            }
            if (actualValueList.size() != 1) {
                AssertionErrors.fail("Got a list of values " + actualValue + " instead of the value " + expectedValue);
            }
            actualValue = actualValueList.get(0);
        } else if (actualValue != null && expectedValue != null) {
            AssertionErrors.assertEquals("For JSON path " + this.expression + " type of value", expectedValue.getClass(), actualValue.getClass());
        }
        AssertionErrors.assertEquals("JSON path " + this.expression, expectedValue, actualValue);
    }

    public void assertValueIsArray(String responseContent) throws ParseException {
        Object actualValue = this.evaluateJsonPath(responseContent);
        AssertionErrors.assertTrue("No value for JSON path \"" + this.expression + "\"", actualValue != null);
        String reason = "Expected array at JSON path " + this.expression + " but found " + actualValue;
        AssertionErrors.assertTrue(reason, actualValue instanceof List);
    }

    public void exists(String content) throws ParseException {
        Object value = this.evaluateJsonPath(content);
        String reason = "No value for JSON path " + this.expression;
        AssertionErrors.assertTrue(reason, value != null);
        if (List.class.isInstance(value)) {
            AssertionErrors.assertTrue(reason, !((List)value).isEmpty());
        }
    }

    public void doesNotExist(String content) throws ParseException {
        Object value;
        try {
            value = this.evaluateJsonPath(content);
        }
        catch (AssertionError ex) {
            return;
        }
        String reason = String.format("Expected no value for JSON path: %s but found: %s", this.expression, value);
        if (List.class.isInstance(value)) {
            AssertionErrors.assertTrue(reason, ((List)value).isEmpty());
        } else {
            AssertionErrors.assertTrue(reason, value == null);
        }
    }
}

