/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import java.net.InetAddress;

public class InetAddressEx {
    public InetAddress address;
    public int mask;

    public InetAddressEx(InetAddress address, int mask) {
        this.address = address;
        this.mask = mask;
    }

    public InetAddressEx(InetAddress address, InetAddress mask) {
        this.address = address;
        this.mask = InetAddressEx.bitsInMask(mask);
    }

    public InetAddressEx(InetAddressEx src) {
        this.address = src.address;
        this.mask = src.mask;
    }

    public String toString() {
        return this.address.getHostAddress().replaceFirst("(^|:)(0+(:|$)){2,8}", "::") + "/" + this.mask;
    }

    public static int bitsInMask(InetAddress mask) {
        byte[] bytes;
        int bits = 0;
        for (byte b : bytes = mask.getAddress()) {
            if (b == 255) {
                bits += 8;
                continue;
            }
            for (int m = 128; m != 0 && (b & m) == m; m >>= 1) {
                ++bits;
            }
        }
        return bits;
    }

    public InetAddress maskFromBits() {
        try {
            int bits;
            byte[] bytes = this.address.getAddress();
            int i = 0;
            for (bits = this.mask; bits > 8; bits -= 8) {
                bytes[i++] = -1;
            }
            int b = -128;
            while (bits > 0) {
                int n = i;
                bytes[n] = (byte)(bytes[n] | b);
                b = (byte)(b >> 1);
                --bits;
            }
            return InetAddress.getByAddress(bytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + this.mask;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InetAddressEx other = (InetAddressEx)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        return this.mask == other.mask;
    }
}

