/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum Severity {
    NORMAL(0),
    WARNING(1),
    MINOR(2),
    MAJOR(3),
    CRITICAL(4),
    UNKNOWN(5),
    TERMINATE(6),
    RESOLVE(7);

    private int value;
    private static Map<Integer, Severity> lookupTable;

    private Severity(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static Severity getByValue(int value) {
        Severity element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)Severity.class.getName(), (String)("Unknown element " + value));
            return NORMAL;
        }
        return element;
    }

    static {
        lookupTable = new HashMap<Integer, Severity>();
        for (Severity element : Severity.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

