/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.views.helpers;

import java.io.IOException;
import java.util.List;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.snmp.SnmpUsmCredential;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class SnmpConfig {
    private List<String> communities;
    private List<SnmpUsmCredential> usmCredentials;

    private SnmpConfig() {
    }

    public static SnmpConfig load() throws NXCException, IOException {
        SnmpConfig config = new SnmpConfig();
        NXCSession session = ConsoleSharedData.getSession();
        config.communities = session.getSnmpCommunities();
        config.usmCredentials = session.getSnmpUsmCredentials();
        return config;
    }

    public void save() throws NXCException, IOException {
        NXCSession session = ConsoleSharedData.getSession();
        session.updateSnmpCommunities(this.communities);
        session.updateSnmpUsmCredentials(this.usmCredentials);
    }

    public List<String> getCommunities() {
        return this.communities;
    }

    public void setCommunities(List<String> communities) {
        this.communities = communities;
    }

    public List<SnmpUsmCredential> getUsmCredentials() {
        return this.usmCredentials;
    }

    public void setUsmCredentials(List<SnmpUsmCredential> usmCredentials) {
        this.usmCredentials = usmCredentials;
    }
}

