/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.widgets.helpers;

import java.util.ArrayList;
import java.util.List;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AlarmListFilter {
    private List<Long> rootObjects = new ArrayList<Long>();
    private int stateFilter = -1;
    private int severityFilter = 255;
    private NXCSession session = ConsoleSharedData.getSession();

    public boolean select(Alarm alarm) {
        if (this.stateFilter != -1 && alarm.getState() != this.stateFilter) {
            return false;
        }
        if ((1 << alarm.getCurrentSeverity().getValue() & this.severityFilter) == 0) {
            return false;
        }
        if (this.rootObjects.size() == 0 || this.rootObjects.contains(alarm.getSourceObjectId())) {
            return true;
        }
        AbstractObject object = this.session.findObjectById(alarm.getSourceObjectId());
        if (object != null) {
            long[] rootObjectsArray = new long[this.rootObjects.size()];
            int i = 0;
            for (long objectId : this.rootObjects) {
                rootObjectsArray[i++] = objectId;
            }
            return object.isChildOf(rootObjectsArray);
        }
        return false;
    }

    public final void setRootObject(long rootObject) {
        this.rootObjects.clear();
        this.rootObjects.add(rootObject);
    }

    public void setRootObjects(List<Long> selectedObjects) {
        this.rootObjects.clear();
        this.rootObjects.addAll(selectedObjects);
    }

    public void setStateFilter(int stateFilter) {
        this.stateFilter = stateFilter;
    }

    public void setSeverityFilter(int severityFilter) {
        this.severityFilter = severityFilter;
    }
}

