/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.IllegalFormatException;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.SimpleDciValue;
import org.netxms.client.datacollection.TableDciValue;
import org.netxms.client.datacollection.Threshold;

public abstract class DciValue {
    private long id;
    private long nodeId;
    private long templateDciId;
    private String name;
    private String description;
    private String value;
    private int source;
    private int dataType;
    private int status;
    private int errorCount;
    private int dcObjectType;
    private Date timestamp;
    private Threshold activeThreshold;

    public static DciValue createFromMessage(long nodeId, NXCPMessage msg, long base) {
        int type = msg.getFieldAsInt32(base + 8L);
        switch (type) {
            case 1: {
                return new SimpleDciValue(nodeId, msg, base);
            }
            case 2: {
                return new TableDciValue(nodeId, msg, base);
            }
        }
        return null;
    }

    protected DciValue(long nodeId, NXCPMessage msg, long base) {
        long fieldId = base;
        this.nodeId = nodeId;
        this.id = msg.getFieldAsInt64(fieldId++);
        this.name = msg.getFieldAsString(fieldId++);
        this.description = msg.getFieldAsString(fieldId++);
        this.source = msg.getFieldAsInt32(fieldId++);
        this.dataType = msg.getFieldAsInt32(fieldId++);
        this.value = msg.getFieldAsString(fieldId++);
        this.timestamp = msg.getFieldAsDate(fieldId++);
        this.status = msg.getFieldAsInt32(fieldId++);
        this.dcObjectType = msg.getFieldAsInt32(fieldId++);
        this.errorCount = msg.getFieldAsInt32(fieldId++);
        this.templateDciId = msg.getFieldAsInt64(fieldId++);
        this.activeThreshold = msg.getFieldAsBoolean(fieldId++) ? new Threshold(msg, fieldId) : null;
    }

    public DciValue(long id, String value, int dataType, int status) {
        this.id = id;
        this.value = value;
        this.dataType = dataType;
        this.status = status;
    }

    private Value getValueForFormat(boolean useMultipliers) {
        Value v = new Value();
        v.suffix = "";
        try {
            switch (this.dataType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (useMultipliers) {
                        long i = Long.parseLong(this.value);
                        if (i >= 10000000000000L || i <= -10000000000000L) {
                            i /= 1000000000000L;
                            v.suffix = "T";
                        }
                        if (i >= 10000000000L || i <= -10000000000L) {
                            i /= 1000000000L;
                            v.suffix = "G";
                        }
                        if (i >= 10000000L || i <= -10000000L) {
                            i /= 1000000L;
                            v.suffix = "M";
                        }
                        if (i >= 10000L || i <= -10000L) {
                            i /= 1000L;
                            v.suffix = "K";
                        }
                        v.value = i;
                        break;
                    }
                    v.value = Long.parseLong(this.value);
                    break;
                }
                case 5: {
                    if (useMultipliers) {
                        double d = Double.parseDouble(this.value);
                        NumberFormat nf = NumberFormat.getNumberInstance();
                        nf.setMaximumFractionDigits(2);
                        if (d >= 1.0E13 || d <= -1.0E13) {
                            d /= 1.0E12;
                            v.suffix = "T";
                        }
                        if (d >= 1.0E10 || d <= -1.0E10) {
                            d /= 1.0E9;
                            v.suffix = "G";
                        }
                        if (d >= 1.0E7 || d <= -1.0E7) {
                            d /= 1000000.0;
                            v.suffix = "M";
                        }
                        if (d >= 10000.0 || d <= -10000.0) {
                            d /= 1000.0;
                            v.suffix = "K";
                        }
                        v.value = d;
                        break;
                    }
                    v.value = Double.parseDouble(this.value);
                    break;
                }
                default: {
                    v.value = this.value;
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            v.value = this.value;
        }
        return v;
    }

    public String format(String formatString) {
        StringBuilder sb = new StringBuilder();
        char[] format = formatString.toCharArray();
        int i = 0;
        while (i < format.length) {
            if (format[i] == '%') {
                if (format[++i] == '%') {
                    sb.append('%');
                } else {
                    int j = i;
                    while (!Character.isLetter(format[j]) && j < format.length) {
                        ++j;
                    }
                    boolean useMultipliers = false;
                    if (format[i] == '*') {
                        ++i;
                        useMultipliers = true;
                    }
                    String f = "%" + new String(Arrays.copyOfRange(format, i, j + 1));
                    i = j;
                    try {
                        Value v = this.getValueForFormat(useMultipliers);
                        sb.append(String.format(f, v.value));
                        sb.append(v.suffix);
                    }
                    catch (IllegalFormatException illegalFormatException) {
                        sb.append("<INVALID FORMAT> (" + f + ")");
                    }
                }
            } else {
                sb.append(format[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }

    public int getSource() {
        return this.source;
    }

    public int getDataType() {
        return this.dataType;
    }

    public int getStatus() {
        return this.status;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public Threshold getActiveThreshold() {
        return this.activeThreshold;
    }

    public int getDcObjectType() {
        return this.dcObjectType;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public final long getTemplateDciId() {
        return this.templateDciId;
    }

    public Severity getThresholdSeverity() {
        return this.activeThreshold != null ? this.activeThreshold.getCurrentSeverity() : Severity.NORMAL;
    }

    private class Value {
        Object value;
        String suffix;

        private Value() {
        }
    }
}

