/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.nxsl.widgets;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.ui.eclipse.nxsl.Activator;
import org.netxms.ui.eclipse.nxsl.widgets.internal.NXSLDocument;
import org.netxms.ui.eclipse.nxsl.widgets.internal.NXSLSourceViewerConfiguration;

public class ScriptEditor
extends Composite {
    private SourceViewer editor;
    private CompositeRuler ruler;
    private Set<String> functions = new HashSet<String>(0);
    private Set<String> variables = new HashSet<String>(0);
    private String[] functionsCache = new String[0];
    private String[] variablesCache = new String[0];
    private Image[] proposalIcons = new Image[4];

    public ScriptEditor(Composite parent, int style, int editorStyle) {
        this(parent, style, editorStyle, true);
    }

    public ScriptEditor(Composite parent, int style, int editorStyle, boolean showLineNumbers) {
        super(parent, style);
        this.proposalIcons[0] = Activator.getImageDescriptor("icons/function.gif").createImage();
        this.proposalIcons[1] = Activator.getImageDescriptor("icons/var_global.gif").createImage();
        this.proposalIcons[2] = Activator.getImageDescriptor("icons/var_local.gif").createImage();
        this.proposalIcons[3] = Activator.getImageDescriptor("icons/constant.gif").createImage();
        this.setLayout((Layout)new FillLayout());
        this.ruler = new CompositeRuler();
        this.editor = new SourceViewer((Composite)this, (IVerticalRuler)this.ruler, editorStyle);
        this.editor.configure((SourceViewerConfiguration)new NXSLSourceViewerConfiguration(this));
        if (showLineNumbers) {
            this.ruler.addDecorator(0, (IVerticalRulerColumn)new LineNumberRulerColumn());
        }
        final TextViewerUndoManager undoManager = new TextViewerUndoManager(50);
        this.editor.setUndoManager((IUndoManager)undoManager);
        undoManager.connect((ITextViewer)this.editor);
        this.editor.getFindReplaceTarget();
        this.editor.prependVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (!event.doit) {
                    return;
                }
                if (event.stateMask == SWT.MOD1) {
                    switch (event.character) {
                        case ' ': {
                            ScriptEditor.this.editor.doOperation(13);
                            event.doit = false;
                            break;
                        }
                        case '\u0019': {
                            undoManager.redo();
                            event.doit = false;
                            break;
                        }
                        case '\u001a': {
                            undoManager.undo();
                            event.doit = false;
                        }
                    }
                } else if (event.stateMask == 0) {
                    if (event.character == '\t' && ((ScriptEditor)ScriptEditor.this).editor.getSelectedRange().y > 0) {
                        ScriptEditor.this.editor.doOperation(8);
                        event.doit = false;
                    }
                } else if (event.stateMask == 131072 && event.character == '\t' && ((ScriptEditor)ScriptEditor.this).editor.getSelectedRange().y > 0) {
                    ScriptEditor.this.editor.doOperation(9);
                    event.doit = false;
                }
            }
        });
        StyledText control = this.editor.getTextWidget();
        control.setFont(JFaceResources.getTextFont());
        control.setWordWrap(false);
        this.editor.setDocument((IDocument)new NXSLDocument(""));
    }

    public void dispose() {
        int i = 0;
        while (i < this.proposalIcons.length) {
            this.proposalIcons[i].dispose();
            ++i;
        }
        super.dispose();
    }

    public StyledText getTextWidget() {
        return this.editor.getTextWidget();
    }

    public void setText(String text) {
        this.editor.setDocument((IDocument)new NXSLDocument(text));
    }

    public String getText() {
        return this.editor.getDocument().get();
    }

    public void setFunctions(Set<String> functions) {
        this.functions = functions;
        this.functionsCache = functions.toArray(new String[functions.size()]);
    }

    public void addFunctions(Collection<String> fc) {
        this.functions.addAll(fc);
        this.functionsCache = this.functions.toArray(new String[this.functions.size()]);
    }

    public void setVariables(Set<String> variables) {
        this.variables = variables;
        this.variablesCache = variables.toArray(new String[variables.size()]);
    }

    public void addVariables(Collection<String> vc) {
        this.variables.addAll(vc);
        this.variablesCache = this.variables.toArray(new String[this.variables.size()]);
    }

    public String[] getFunctions() {
        return this.functionsCache;
    }

    public String[] getVariables() {
        return this.variablesCache;
    }

    public Image getProposalIcon(int type) {
        try {
            return this.proposalIcons[type];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public IFindReplaceTarget getFindReplaceTarget() {
        return this.editor.getFindReplaceTarget();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point p = this.editor.getTextWidget().computeSize(wHint, hHint, changed);
        p.y += 4;
        return p;
    }

    public void showLineNumbers(boolean show) {
        if (show) {
            if (!this.ruler.getDecoratorIterator().hasNext()) {
                this.ruler.addDecorator(0, (IVerticalRulerColumn)new LineNumberRulerColumn());
            }
        } else if (this.ruler.getDecoratorIterator().hasNext()) {
            this.ruler.removeDecorator(0);
        }
    }
}

