/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.objects.AbstractNode;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class NodePolling
extends PropertyPage {
    private AbstractNode object;
    private ObjectSelector pollerNode;
    private Button radioIfXTableDefault;
    private Button radioIfXTableEnable;
    private Button radioIfXTableDisable;
    private Button radioAgentCacheDefault;
    private Button radioAgentCacheOn;
    private Button radioAgentCacheOff;
    private List<Button> flagButtons = new ArrayList<Button>();
    private List<Integer> flagValues = new ArrayList<Integer>();

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AbstractNode)this.getElement().getAdapter(AbstractNode.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Group servicePollGroup = new Group(dialogArea, 0);
        Messages.get();
        servicePollGroup.setText(Messages.NodePolling_GroupNetSrv);
        layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.numColumns = 2;
        servicePollGroup.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        servicePollGroup.setLayoutData((Object)gd);
        this.pollerNode = new ObjectSelector((Composite)servicePollGroup, 0, true);
        Messages.get();
        this.pollerNode.setLabel(Messages.NodePolling_PollerNode);
        this.pollerNode.setObjectClass(AbstractNode.class);
        Messages.get();
        this.pollerNode.setEmptySelectionName(Messages.NodePolling_EmptySelectionServer);
        this.pollerNode.setObjectId(this.object.getPollerNodeId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.pollerNode.setLayoutData((Object)gd);
        Label label = new Label((Composite)servicePollGroup, 64);
        Messages.get();
        label.setText(Messages.NodePolling_PollerNodeDescription);
        gd = new GridData();
        gd.widthHint = 250;
        label.setLayoutData((Object)gd);
        Group optionsGroup = new Group(dialogArea, 0);
        Messages.get();
        optionsGroup.setText(Messages.NodePolling_GroupOptions);
        layout = new GridLayout();
        layout.verticalSpacing = 5;
        optionsGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        Messages.get();
        this.addFlag((Composite)optionsGroup, 0x2000000, Messages.NodePolling_OptDisableAgent);
        Messages.get();
        this.addFlag((Composite)optionsGroup, 0x1000000, Messages.NodePolling_OptDisableSNMP);
        Messages.get();
        this.addFlag((Composite)optionsGroup, 0x4000000, Messages.NodePolling_OptDisableICMP);
        Messages.get();
        this.addFlag((Composite)optionsGroup, 0x10000000, Messages.NodePolling_OptDisableStatusPoll);
        Messages.get();
        this.addFlag((Composite)optionsGroup, 0x20000000, Messages.NodePolling_OptDisableConfigPoll);
        Messages.get();
        this.addFlag((Composite)optionsGroup, 0x40000000, Messages.NodePolling_OptDisableRTPoll);
        Messages.get();
        this.addFlag((Composite)optionsGroup, 0x800000, Messages.NodePolling_OptDisableTopoPoll);
        Messages.get();
        this.addFlag((Composite)optionsGroup, 0x400000, Messages.NodePolling_OptDisableDiscoveryPoll);
        Messages.get();
        this.addFlag((Composite)optionsGroup, Integer.MIN_VALUE, Messages.NodePolling_OptDisableDataCollection);
        Group ifXTableGroup = new Group(dialogArea, 0);
        Messages.get();
        ifXTableGroup.setText(Messages.NodePolling_GroupIfXTable);
        layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        ifXTableGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        ifXTableGroup.setLayoutData((Object)gd);
        this.radioIfXTableDefault = new Button((Composite)ifXTableGroup, 16);
        Messages.get();
        this.radioIfXTableDefault.setText(Messages.NodePolling_Default);
        this.radioIfXTableDefault.setSelection(this.object.getIfXTablePolicy() == 0);
        this.radioIfXTableEnable = new Button((Composite)ifXTableGroup, 16);
        Messages.get();
        this.radioIfXTableEnable.setText(Messages.NodePolling_Enable);
        this.radioIfXTableEnable.setSelection(this.object.getIfXTablePolicy() == 1);
        this.radioIfXTableDisable = new Button((Composite)ifXTableGroup, 16);
        Messages.get();
        this.radioIfXTableDisable.setText(Messages.NodePolling_Disable);
        this.radioIfXTableDisable.setSelection(this.object.getIfXTablePolicy() == 2);
        Group agentCacheGroup = new Group(dialogArea, 0);
        agentCacheGroup.setText("Agent cache mode");
        layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        agentCacheGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        agentCacheGroup.setLayoutData((Object)gd);
        this.radioAgentCacheDefault = new Button((Composite)agentCacheGroup, 16);
        Messages.get();
        this.radioAgentCacheDefault.setText(Messages.NodePolling_Default);
        this.radioAgentCacheDefault.setSelection(this.object.getAgentCacheMode() == AgentCacheMode.DEFAULT);
        this.radioAgentCacheOn = new Button((Composite)agentCacheGroup, 16);
        this.radioAgentCacheOn.setText("On");
        this.radioAgentCacheOn.setSelection(this.object.getAgentCacheMode() == AgentCacheMode.ON);
        this.radioAgentCacheOff = new Button((Composite)agentCacheGroup, 16);
        this.radioAgentCacheOff.setText("Off");
        this.radioAgentCacheOff.setSelection(this.object.getAgentCacheMode() == AgentCacheMode.OFF);
        return dialogArea;
    }

    private void addFlag(Composite parent, int value, String name) {
        Button button = new Button(parent, 32);
        button.setText(name);
        button.setSelection((this.object.getFlags() & value) != 0);
        this.flagButtons.add(button);
        this.flagValues.add(value);
    }

    private int collectNodeFlags() {
        int flags = this.object.getFlags();
        int i = 0;
        while (i < this.flagButtons.size()) {
            flags = this.flagButtons.get(i).getSelection() ? (flags |= this.flagValues.get(i).intValue()) : (flags &= ~this.flagValues.get(i).intValue());
            ++i;
        }
        return flags;
    }

    private int collectIfXTablePolicy() {
        if (this.radioIfXTableEnable.getSelection()) {
            return 1;
        }
        if (this.radioIfXTableDisable.getSelection()) {
            return 2;
        }
        return 0;
    }

    private AgentCacheMode collectAgentCacheMode() {
        if (this.radioAgentCacheOn.getSelection()) {
            return AgentCacheMode.ON;
        }
        if (this.radioAgentCacheOff.getSelection()) {
            return AgentCacheMode.OFF;
        }
        return AgentCacheMode.DEFAULT;
    }

    protected boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setPollerNode(this.pollerNode.getObjectId());
        md.setObjectFlags(this.collectNodeFlags());
        md.setIfXTablePolicy(this.collectIfXTablePolicy());
        md.setAgentCacheMode(this.collectAgentCacheMode());
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.NodePolling_JobName, null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.NodePolling_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            NodePolling.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.pollerNode.setObjectId(0L);
        this.radioIfXTableDefault.setSelection(true);
        this.radioIfXTableDisable.setSelection(false);
        this.radioIfXTableEnable.setSelection(false);
        for (Button b : this.flagButtons) {
            b.setSelection(false);
        }
    }
}

