/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.AgentFile;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.widgets.TextViewWidget;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class FileViewer
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.objecttools.views.FileViewer";
    private final NXCSession session = ConsoleSharedData.getSession();
    private TextViewWidget textViewer;
    private String remoteFileName;
    private long nodeId;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String[] parts = site.getSecondaryId().split("&");
        if (parts.length != 2) {
            throw new PartInitException("Internal error");
        }
        this.nodeId = Long.parseLong(parts[0]);
        AbstractObject object = this.session.findObjectById(this.nodeId);
        if (object == null || object.getObjectClass() != 2) {
            Messages.get();
            throw new PartInitException(Messages.FileViewer_InvalidObjectID);
        }
        try {
            this.remoteFileName = URLDecoder.decode(parts[1], "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new PartInitException("Internal error", (Throwable)e);
        }
        this.setPartName(String.valueOf(object.getObjectName()) + ": " + this.remoteFileName);
    }

    public void createPartControl(Composite parent) {
        this.textViewer = new TextViewWidget(parent, 2048, this.remoteFileName, this.nodeId, (IViewPart)this);
        this.activateContext();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.objecttools.context.FileViewer");
        }
    }

    public void setFocus() {
        this.textViewer.setFocus();
    }

    public static boolean createView(IWorkbenchWindow window, Shell shell, final AgentFile file, boolean tail, int offset, String secondaryId, final long nodeId) throws PartInitException {
        boolean exceedSize;
        boolean bl = exceedSize = file.getFile().length() > 0x7D0000L;
        if (exceedSize && !MessageDialogHelper.openConfirm((Shell)shell, (String)"File is too large", (String)"File is too large to be fully shown. Click OK to see beginning of the file.")) {
            if (tail) {
                final NXCSession session = ConsoleSharedData.getSession();
                Messages.get();
                ConsoleJob job = new ConsoleJob(Messages.FileViewer_Stop_File_Monitoring, null, "org.netxms.ui.eclipse.objecttools", null){

                    protected void runInternal(IProgressMonitor monitor) throws Exception {
                        session.cancelFileMonitoring(nodeId, file.getId());
                    }

                    protected String getErrorMessage() {
                        Messages.get();
                        return Messages.FileViewer_Cannot_Stop_File_Monitoring;
                    }
                };
                job.setUser(false);
                job.setSystem(true);
                job.start();
            }
            return false;
        }
        FileViewer view = (FileViewer)window.getActivePage().showView(ID, secondaryId, 1);
        view.textViewer.showFile(file.getFile(), tail, file.getId(), offset, exceedSize);
        return true;
    }
}

