/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.widgets;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.handlers.IHandlerService;
import org.netxms.client.AgentFile;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Activator;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.CompositeWithMessageBar;

public class TextViewWidget
extends CompositeWithMessageBar {
    public static final long MAX_FILE_SIZE = 0x7D0000L;
    private StyledText textViewer;
    private Action actionClear;
    private Action actionScrollLock;
    private Action actionCopy;
    private Action actionSelectAll;
    private String remoteFileName;
    private long nodeId;
    private String fileID;
    private File currentFile;
    private long offset = 0L;
    private boolean follow;
    private ConsoleJob monitorJob;
    private ConsoleJob tryToRestartMonitoring;
    private SessionListener listener;
    private IViewPart viewPart;
    private final NXCSession session = ConsoleSharedData.getSession();

    public TextViewWidget(Composite parent, int style, String remoteFileName, long nodeId, IViewPart viewPart) {
        super(parent, style);
        this.remoteFileName = remoteFileName;
        this.nodeId = nodeId;
        this.viewPart = viewPart;
        this.textViewer = new StyledText(this.getContent(), 768);
        this.textViewer.setEditable(false);
        this.textViewer.setFont(JFaceResources.getTextFont());
        this.textViewer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextViewWidget.this.actionCopy.setEnabled(TextViewWidget.this.textViewer.getSelectionCount() > 0);
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.viewPart.getSite().getService(IHandlerService.class);
        Messages.get();
        this.actionClear = new Action(Messages.FileViewer_ClearOutput, SharedIcons.CLEAR_LOG){

            public void run() {
                TextViewWidget.this.textViewer.setText("");
            }
        };
        this.actionClear.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.clear_output");
        handlerService.activateHandler(this.actionClear.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionClear));
        Messages.get();
        this.actionScrollLock = new Action(Messages.FileViewer_ScrollLock, 2){

            public void run() {
            }
        };
        this.actionScrollLock.setImageDescriptor(Activator.getImageDescriptor("icons/scroll_lock.gif"));
        this.actionScrollLock.setChecked(false);
        this.actionScrollLock.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.scroll_lock");
        handlerService.activateHandler(this.actionScrollLock.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionScrollLock));
        Messages.get();
        this.actionCopy = new Action(Messages.LocalCommandResults_Copy){

            public void run() {
                TextViewWidget.this.textViewer.copy();
            }
        };
        this.actionCopy.setEnabled(false);
        this.actionCopy.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.copy");
        handlerService.activateHandler(this.actionCopy.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionCopy));
        Messages.get();
        this.actionSelectAll = new Action(Messages.LocalCommandResults_SelectAll){

            public void run() {
                TextViewWidget.this.textViewer.selectAll();
                TextViewWidget.this.actionCopy.setEnabled(TextViewWidget.this.textViewer.getSelectionCount() > 0);
            }
        };
        this.actionSelectAll.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.select_all");
        handlerService.activateHandler(this.actionSelectAll.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionSelectAll));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.viewPart.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionClear);
        manager.add((IAction)this.actionScrollLock);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelectAll);
        manager.add((IAction)this.actionCopy);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionClear);
        manager.add((IAction)this.actionScrollLock);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TextViewWidget.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.textViewer);
        this.textViewer.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionClear);
        manager.add((IAction)this.actionScrollLock);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelectAll);
        manager.add((IAction)this.actionCopy);
    }

    public void showFile(File file, boolean follow, String id, int maxFileSize, boolean exceedSize) {
        this.currentFile = file;
        this.fileID = id;
        this.offset = maxFileSize;
        this.setContent(this.loadFile(this.currentFile));
        this.textViewer.setTopIndex(this.textViewer.getLineCount());
        this.follow = follow;
        if (follow) {
            Messages.get();
            this.monitorJob = new ConsoleJob(Messages.FileViewer_Download_File_Updates, null, "org.netxms.ui.eclipse.objecttools", null){
                private boolean continueWork;
                {
                    this.continueWork = true;
                }

                protected void canceling() {
                    this.continueWork = false;
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    while (this.continueWork) {
                        final String s = TextViewWidget.this.session.waitForFileTail(TextViewWidget.this.fileID, 3000);
                        if (s == null) continue;
                        this.runInUIThread(new Runnable(){

                            @Override
                            public void run() {
                                if (!TextViewWidget.this.textViewer.isDisposed()) {
                                    TextViewWidget.this.appendContent(s);
                                    if (!TextViewWidget.this.actionScrollLock.isChecked()) {
                                        TextViewWidget.this.textViewer.setTopIndex(TextViewWidget.this.textViewer.getLineCount() - 1);
                                    }
                                }
                            }
                        });
                    }
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return String.format(Messages.ObjectToolsDynamicMenu_DownloadError, TextViewWidget.this.remoteFileName, TextViewWidget.this.nodeId);
                }
            };
            this.monitorJob.setUser(false);
            this.monitorJob.setSystem(true);
            this.monitorJob.start();
            this.listener = new SessionListener(){

                public void notificationHandler(SessionNotification n) {
                    switch (n.getCode()) {
                        case 1026: {
                            if (TextViewWidget.this.nodeId != n.getSubCode()) break;
                            TextViewWidget.this.onFileMonitoringFail();
                        }
                    }
                }
            };
            this.session.addListener(this.listener);
        }
        if (exceedSize) {
            this.showMessage(0, "File is too large. Content will be shown partly.");
        }
    }

    private void onFileMonitoringFail() {
        Messages.get();
        this.tryToRestartMonitoring = new ConsoleJob(Messages.FileViewer_RestartFollowingJob, null, "org.netxms.ui.eclipse.objecttools", null){
            private boolean continueWork;
            {
                this.continueWork = true;
            }

            protected void canceling() {
                this.continueWork = false;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!TextViewWidget.this.textViewer.isDisposed()) {
                            TextViewWidget.this.textViewer.setForeground(new Color((Device)this.getDisplay(), 255, 0, 0));
                            StyledText styledText = TextViewWidget.this.textViewer;
                            StringBuilder stringBuilder = new StringBuilder(" \n\n----------------------------------------------------------------------\n");
                            Messages.get();
                            styledText.append(stringBuilder.append(Messages.FileViewer_NotifyFollowConnectionLost).append("\n----------------------------------------------------------------------").append("\n").toString());
                            if (!TextViewWidget.this.actionScrollLock.isChecked()) {
                                TextViewWidget.this.textViewer.setTopIndex(TextViewWidget.this.textViewer.getLineCount() - 1);
                            }
                        }
                    }
                });
                while (this.continueWork) {
                    try {
                        final AgentFile file = TextViewWidget.this.session.downloadFileFromAgent(TextViewWidget.this.nodeId, TextViewWidget.this.remoteFileName, TextViewWidget.this.offset, TextViewWidget.this.follow);
                        this.runInUIThread(new Runnable(){

                            @Override
                            public void run() {
                                if (!TextViewWidget.this.textViewer.isDisposed()) {
                                    StyledText styledText = TextViewWidget.this.textViewer;
                                    StringBuilder stringBuilder = new StringBuilder("-------------------------------------------------------------------------------\n");
                                    Messages.get();
                                    styledText.append(stringBuilder.append(Messages.FileViewer_NotifyFollowConnectionEnabed).append("\n-------------------------------------------------------------------------------").append("\n \n").toString());
                                    TextViewWidget.this.textViewer.setForeground(null);
                                    TextViewWidget.this.loadFile(file.getFile());
                                    if (!TextViewWidget.this.actionScrollLock.isChecked()) {
                                        TextViewWidget.this.textViewer.setTopIndex(TextViewWidget.this.textViewer.getLineCount() - 1);
                                    }
                                }
                            }
                        });
                        this.continueWork = false;
                    }
                    catch (Exception exception) {}
                    Thread.sleep(20000L);
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ObjectToolsDynamicMenu_DownloadError, TextViewWidget.this.remoteFileName, TextViewWidget.this.nodeId);
            }
        };
        this.tryToRestartMonitoring.setUser(false);
        this.tryToRestartMonitoring.setSystem(true);
        this.tryToRestartMonitoring.start();
    }

    public void dispose() {
        if (this.follow) {
            this.monitorJob.cancel();
            if (this.tryToRestartMonitoring != null) {
                this.tryToRestartMonitoring.cancel();
            }
            if (this.tryToRestartMonitoring == null || this.tryToRestartMonitoring.getState() != 4) {
                Messages.get();
                ConsoleJob job = new ConsoleJob(Messages.FileViewer_Stop_File_Monitoring, null, "org.netxms.ui.eclipse.objecttools", null){

                    protected void runInternal(IProgressMonitor monitor) throws Exception {
                        TextViewWidget.this.session.cancelFileMonitoring(TextViewWidget.this.nodeId, TextViewWidget.this.fileID);
                    }

                    protected String getErrorMessage() {
                        Messages.get();
                        return Messages.FileViewer_Cannot_Stop_File_Monitoring;
                    }
                };
                job.setUser(false);
                job.setSystem(true);
                job.start();
            }
        }
        this.session.removeListener(this.listener);
        super.dispose();
    }

    private String loadFile(File file) {
        StringBuilder content;
        block18: {
            content = new StringBuilder();
            FileReader reader = null;
            char[] buffer = new char[32768];
            try {
                try {
                    reader = new FileReader(file);
                    int size = 0;
                    while ((long)size < 0x7D0000L) {
                        int count = reader.read(buffer);
                        if (count != -1) {
                            if (count == buffer.length) {
                                content.append(buffer);
                            } else {
                                content.append(Arrays.copyOf(buffer, count));
                            }
                            size += count;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return content.toString();
    }

    private void setContent(String s) {
        this.textViewer.setText(TextViewWidget.removeEscapeSequences(s));
    }

    private void appendContent(String s) {
        this.textViewer.append(TextViewWidget.removeEscapeSequences(s));
    }

    private static String removeEscapeSequences(String s) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '\u001b') {
                if ((ch = s.charAt(++i)) == '[') {
                    while (i < s.length()) {
                        ch = s.charAt(i);
                        if (!(ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z')) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                } else if (ch == '(' || ch == ')') {
                    ++i;
                }
            } else if (ch >= ' ' || ch == '\r' || ch == '\n' || ch == '\t') {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }
}

