/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.widgets.Control;

public class RefreshTimer {
    private static ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(4);
    private Control control;
    private Runnable callback;
    private long interval;
    private long lastRun = 0L;
    private boolean scheduled = false;

    public RefreshTimer(int interval, Control control, Runnable callback) {
        this.interval = interval;
        this.control = control;
        this.callback = callback;
    }

    public synchronized void execute() {
        if (this.control.isDisposed()) {
            return;
        }
        long curr = System.currentTimeMillis();
        if (this.interval <= 0L || curr - this.lastRun >= this.interval) {
            this.lastRun = curr;
            this.control.getDisplay().asyncExec(this.callback);
        } else if (!this.scheduled) {
            int delay = (int)(this.interval - (curr - this.lastRun));
            this.scheduled = true;
            executor.schedule(new Runnable(){

                @Override
                public void run() {
                    RefreshTimer.this.control.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!RefreshTimer.this.control.isDisposed()) {
                                RefreshTimer.this.callback.run();
                            }
                            RefreshTimer.this.onTimer();
                        }
                    });
                }
            }, (long)delay, TimeUnit.MILLISECONDS);
        }
    }

    private synchronized void onTimer() {
        this.lastRun = System.currentTimeMillis();
        this.scheduled = false;
    }
}

