/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.objects.DashboardRoot;
import org.netxms.client.reporting.ReportDefinition;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.reporter.widgets.internal.ReportTreeContentProvider;
import org.netxms.ui.eclipse.reporter.widgets.internal.ReportTreeLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ReportNavigator
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.reporter.views.ReportNavigator";
    private NXCSession session;
    private TreeViewer reportTree;
    private RefreshAction actionRefresh;
    private SessionListener sessionListener;

    public void createPartControl(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        this.reportTree = new TreeViewer(parent, 0);
        this.reportTree.setContentProvider((IContentProvider)new ReportTreeContentProvider());
        this.reportTree.setLabelProvider((IBaseLabelProvider)new ReportTreeLabelProvider());
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.reportTree);
        this.sessionListener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 4 && n.getObject() instanceof DashboardRoot) {
                    ReportNavigator.this.reportTree.getTree().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ReportNavigator.this.refresh();
                        }
                    });
                }
            }
        };
        this.session.addListener(this.sessionListener);
        this.refresh();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                ReportNavigator.this.refresh();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ReportNavigator.this.fillContextMenu(mgr);
            }
        });
        Menu menu = manager.createContextMenu((Control)this.reportTree.getTree());
        this.reportTree.getTree().setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.reportTree);
    }

    protected void fillContextMenu(IMenuManager manager) {
    }

    public void setFocus() {
        this.reportTree.getTree().setFocus();
    }

    private void refresh() {
        new ConsoleJob("Load Reports", null, "org.netxms.ui.eclipse.reporter", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final ArrayList<UUID> notGeneratedReport = new ArrayList<UUID>(0);
                final ArrayList<ReportDefinition> definitions = new ArrayList<ReportDefinition>();
                List reportIds = ReportNavigator.this.session.listReports();
                for (UUID reportId : reportIds) {
                    try {
                        ReportDefinition definition = ReportNavigator.this.session.getReportDefinition(reportId);
                        definitions.add(definition);
                    }
                    catch (NXCException e) {
                        if (e.getErrorCode() != 46) continue;
                        notGeneratedReport.add(reportId);
                    }
                }
                Collections.sort(definitions, new Comparator<ReportDefinition>(){

                    @Override
                    public int compare(ReportDefinition o1, ReportDefinition o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ReportNavigator.this.reportTree.setInput((Object)definitions);
                        if (notGeneratedReport.size() > 0) {
                            String errorMessage = "Can't load compiled report: ";
                            int i = 0;
                            while (i < notGeneratedReport.size()) {
                                errorMessage = String.valueOf(errorMessage) + ((UUID)notGeneratedReport.get(i)).toString() + (i == notGeneratedReport.size() - 1 ? "" : ", ");
                                ++i;
                            }
                            MessageDialog.openError(null, (String)"Error", (String)errorMessage);
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Failed to load reports from the server";
            }
        }.start();
    }

    public void dispose() {
        if (this.session != null && this.sessionListener != null) {
            this.session.removeListener(this.sessionListener);
        }
        super.dispose();
    }
}

