/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.EntireNetwork;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.ui.eclipse.filemanager.Messages;
import org.netxms.ui.eclipse.filemanager.dialogs.StartServerToAgentFileUploadDialog;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class UploadFileToAgent
implements IObjectActionDelegate {
    private Shell shell;
    private ViewPart viewPart;
    private Set<Long> nodes = new HashSet<Long>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.viewPart = targetPart instanceof ViewPart ? (ViewPart)targetPart : null;
    }

    public void run(IAction action) {
        final StartServerToAgentFileUploadDialog dlg = new StartServerToAgentFileUploadDialog(this.shell);
        if (dlg.open() == 0) {
            final NXCSession session = ConsoleSharedData.getSession();
            final Long[] nodeIdList = this.nodes.toArray(new Long[this.nodes.size()]);
            Messages.get();
            new ConsoleJob(Messages.UploadFileToAgent_JobTitle, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.filemanager", null){

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.UploadFileToAgent_JobError;
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    String remoteFileName = dlg.getRemoteFileName();
                    if (!remoteFileName.isEmpty()) {
                        if (remoteFileName.endsWith("/") || remoteFileName.endsWith("\\")) {
                            remoteFileName = String.valueOf(remoteFileName) + dlg.getServerFile().getName();
                        }
                    } else {
                        remoteFileName = null;
                    }
                    int i = 0;
                    while (i < nodeIdList.length) {
                        session.uploadFileToAgent(nodeIdList[i].longValue(), dlg.getServerFile().getName(), remoteFileName, dlg.isCreateJobOnHold());
                        ++i;
                    }
                }
            }.start();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.nodes.clear();
        if (!(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        for (Object object : (IStructuredSelection)selection) {
            if (object instanceof Node) {
                this.nodes.add(((Node)object).getObjectId());
                continue;
            }
            if (!(object instanceof Container) && !(object instanceof ServiceRoot) && !(object instanceof Subnet) && !(object instanceof EntireNetwork)) continue;
            Set set = ((AbstractObject)object).getAllChilds(2);
            for (AbstractObject o : set) {
                this.nodes.add(o.getObjectId());
            }
        }
        action.setEnabled(this.nodes.size() > 0);
    }
}

