/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.layout.util;

import java.util.Map;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.LabelBlock;
import org.eclipse.birt.chart.model.layout.LayoutPackage;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutValidator
extends EObjectValidator {
    public static final LayoutValidator INSTANCE = new LayoutValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.birt.chart.model.layout";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;
    public static final int ELLIPSIS_TYPE__MIN__VALUE = 0;
    public static final double TITLE_PERCENT_TYPE__MIN__VALUE = 0.0;
    public static final double TITLE_PERCENT_TYPE__MAX__VALUE = 1.0;

    protected EPackage getEPackage() {
        return LayoutPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateBlock((Block)value, diagnostics, context);
            }
            case 1: {
                return this.validateClientArea((ClientArea)value, diagnostics, context);
            }
            case 2: {
                return this.validateLabelBlock((LabelBlock)value, diagnostics, context);
            }
            case 3: {
                return this.validateLegend((Legend)value, diagnostics, context);
            }
            case 4: {
                return this.validatePlot((Plot)value, diagnostics, context);
            }
            case 5: {
                return this.validateTitleBlock((TitleBlock)value, diagnostics, context);
            }
            case 6: {
                return this.validateEllipsisType((Integer)value, diagnostics, context);
            }
            case 7: {
                return this.validateEllipsisTypeObject((Integer)value, diagnostics, context);
            }
            case 8: {
                return this.validateTitlePercentType((Double)value, diagnostics, context);
            }
            case 9: {
                return this.validateTitlePercentTypeObject((Double)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateBlock(Block block, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(block, diagnostics, context);
    }

    public boolean validateClientArea(ClientArea clientArea, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(clientArea, diagnostics, context);
    }

    public boolean validateLabelBlock(LabelBlock labelBlock, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(labelBlock, diagnostics, context);
    }

    public boolean validateLegend(Legend legend, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(legend, diagnostics, context);
    }

    public boolean validatePlot(Plot plot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(plot, diagnostics, context);
    }

    public boolean validateTitleBlock(TitleBlock titleBlock, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(titleBlock, diagnostics, context);
    }

    public boolean validateEllipsisType(int ellipsisType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateEllipsisType_Min(ellipsisType, diagnostics, context);
        return result;
    }

    public boolean validateEllipsisType_Min(int ellipsisType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = result = ellipsisType >= 0;
        if (!result && diagnostics != null) {
            this.reportMinViolation(LayoutPackage.Literals.ELLIPSIS_TYPE, ellipsisType, 0, true, diagnostics, context);
        }
        return result;
    }

    public boolean validateEllipsisTypeObject(Integer ellipsisTypeObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateEllipsisType_Min(ellipsisTypeObject, diagnostics, context);
        return result;
    }

    public boolean validateTitlePercentType(double titlePercentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateTitlePercentType_Min(titlePercentType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateTitlePercentType_Max(titlePercentType, diagnostics, context);
        }
        return result;
    }

    public boolean validateTitlePercentType_Min(double titlePercentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = result = titlePercentType >= 0.0;
        if (!result && diagnostics != null) {
            this.reportMinViolation(LayoutPackage.Literals.TITLE_PERCENT_TYPE, titlePercentType, 0.0, true, diagnostics, context);
        }
        return result;
    }

    public boolean validateTitlePercentType_Max(double titlePercentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = result = titlePercentType <= 1.0;
        if (!result && diagnostics != null) {
            this.reportMaxViolation(LayoutPackage.Literals.TITLE_PERCENT_TYPE, titlePercentType, 1.0, true, diagnostics, context);
        }
        return result;
    }

    public boolean validateTitlePercentTypeObject(Double titlePercentTypeObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateTitlePercentType_Min(titlePercentTypeObject, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateTitlePercentType_Max(titlePercentTypeObject, diagnostics, context);
        }
        return result;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

