/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyClass$PyExposer;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFinalizableInstance;
import org.python.core.PyInstance;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="classobj", isBaseType=false)
public class PyClass
extends PyObject {
    public static final PyType TYPE;
    public PyObject __dict__;
    public PyTuple __bases__;
    public String __name__;
    PyObject __getattr__;
    PyObject __setattr__;
    PyObject __delattr__;
    PyObject __tojava__;
    PyObject __del__;
    PyObject __contains__;

    private PyClass() {
        super(TYPE);
    }

    @ExposedNew
    public static PyObject classobj___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("function", args, keywords, "name", "bases", "dict");
        PyObject name = ap.getPyObject(0);
        PyObject bases = ap.getPyObject(1);
        PyObject dict = ap.getPyObject(2);
        return PyClass.classobj___new__(name, bases, dict);
    }

    public static PyObject classobj___new__(PyObject name, PyObject bases, PyObject dict) {
        if (!name.getType().isSubType(PyString.TYPE)) {
            throw Py.TypeError("PyClass_New: name must be a string");
        }
        if (!(dict instanceof PyStringMap) && !(dict instanceof PyDictionary)) {
            throw Py.TypeError("PyClass_New: dict must be a dictionary");
        }
        PyType.ensureDoc(dict);
        PyType.ensureModule(dict);
        if (!(bases instanceof PyTuple)) {
            throw Py.TypeError("PyClass_New: bases must be a tuple");
        }
        PyTuple basesTuple = (PyTuple)bases;
        for (PyObject base : basesTuple.getArray()) {
            if (base instanceof PyClass) continue;
            if (base.getType().isCallable()) {
                return base.getType().__call__(name, bases, dict);
            }
            throw Py.TypeError("PyClass_New: base must be a class");
        }
        PyClass klass = new PyClass();
        klass.__name__ = name.toString();
        klass.__bases__ = basesTuple;
        klass.__dict__ = dict;
        klass.cacheDescriptors();
        return klass;
    }

    private void cacheDescriptors() {
        this.__getattr__ = this.lookup("__getattr__");
        this.__setattr__ = this.lookup("__setattr__");
        this.__delattr__ = this.lookup("__delattr__");
        this.__tojava__ = this.lookup("__tojava__");
        this.__del__ = this.lookup("__del__");
        this.__contains__ = this.lookup("__contains__");
    }

    PyObject lookup(String name) {
        PyObject result = this.__dict__.__finditem__(name);
        if (result == null && this.__bases__ != null) {
            PyObject base;
            PyObject[] arr$ = this.__bases__.getArray();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (result = ((PyClass)(base = arr$[i$])).lookup(name)) == null; ++i$) {
            }
        }
        return result;
    }

    @Override
    public PyObject fastGetDict() {
        return this.__dict__;
    }

    @Override
    public PyObject __findattr_ex__(String name) {
        if (name == "__dict__") {
            return this.__dict__;
        }
        if (name == "__bases__") {
            return this.__bases__;
        }
        if (name == "__name__") {
            return Py.newString(this.__name__);
        }
        PyObject result = this.lookup(name);
        if (result == null) {
            return result;
        }
        return result.__get__(null, this);
    }

    @Override
    public void __setattr__(String name, PyObject value) {
        if (name == "__dict__") {
            this.setDict(value);
            return;
        }
        if (name == "__bases__") {
            this.setBases(value);
            return;
        }
        if (name == "__name__") {
            this.setName(value);
            return;
        }
        if (name == "__getattr__") {
            this.__getattr__ = value;
            return;
        }
        if (name == "__setattr__") {
            this.__setattr__ = value;
            return;
        }
        if (name == "__delattr__") {
            this.__delattr__ = value;
            return;
        }
        if (name == "__tojava__") {
            this.__tojava__ = value;
            return;
        }
        if (name == "__del__") {
            this.__del__ = value;
            return;
        }
        if (name == "__contains__") {
            this.__contains__ = value;
            return;
        }
        if (value == null) {
            try {
                this.__dict__.__delitem__(name);
            }
            catch (PyException pye) {
                this.noAttributeError(name);
            }
        }
        this.__dict__.__setitem__(name, value);
    }

    @Override
    public void __delattr__(String name) {
        this.__setattr__(name, null);
    }

    @Override
    public void __rawdir__(PyDictionary accum) {
        this.mergeClassDict(accum, this);
    }

    @Override
    public void noAttributeError(String name) {
        throw Py.AttributeError(String.format("class %.50s has no attribute '%.400s'", this.__name__, name));
    }

    @Override
    public PyObject __call__(PyObject[] args, String[] keywords) {
        PyInstance inst = this.__del__ == null ? new PyInstance(this) : new PyFinalizableInstance(this);
        inst.__init__(args, keywords);
        return inst;
    }

    @Override
    public boolean isCallable() {
        return true;
    }

    @Override
    public int __cmp__(PyObject other) {
        if (!(other instanceof PyClass)) {
            return -2;
        }
        int c = this.__name__.compareTo(((PyClass)other).__name__);
        return c < 0 ? -1 : (c > 0 ? 1 : 0);
    }

    @Override
    public PyString __str__() {
        if (this.__dict__ == null) {
            return new PyString(this.__name__);
        }
        PyObject mod2 = this.__dict__.__finditem__("__module__");
        if (mod2 == null || !(mod2 instanceof PyString)) {
            return new PyString(this.__name__);
        }
        String smod = ((PyString)mod2).toString();
        return new PyString(smod + "." + this.__name__);
    }

    @Override
    public String toString() {
        PyObject mod2 = this.__dict__.__finditem__("__module__");
        String modStr = mod2 == null || !Py.isInstance(mod2, PyString.TYPE) ? "?" : mod2.toString();
        return String.format("<class %s.%s at %s>", modStr, this.__name__, Py.idstr(this));
    }

    public boolean isSubClass(PyClass superclass) {
        if (this == superclass) {
            return true;
        }
        if (this.__bases__ == null || superclass.__bases__ == null) {
            return false;
        }
        for (PyObject base : this.__bases__.getArray()) {
            if (!((PyClass)base).isSubClass(superclass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDict(PyObject value) {
        if (value == null || !(value instanceof PyStringMap) && !(value instanceof PyDictionary)) {
            throw Py.TypeError("__dict__ must be a dictionary object");
        }
        this.__dict__ = value;
    }

    public void setBases(PyObject value) {
        if (value == null || !(value instanceof PyTuple)) {
            throw Py.TypeError("__bases__ must be a tuple object");
        }
        PyTuple bases = (PyTuple)value;
        for (PyObject base : bases.getArray()) {
            if (!(base instanceof PyClass)) {
                throw Py.TypeError("__bases__ items must be classes");
            }
            if (!((PyClass)base).isSubClass(this)) continue;
            throw Py.TypeError("a __bases__ item causes an inheritance cycle");
        }
        this.__bases__ = bases;
    }

    public void setName(PyObject value) {
        if (value == null || !Py.isInstance(value, PyString.TYPE)) {
            throw Py.TypeError("__name__ must be a string object");
        }
        String name = value.toString();
        if (name.contains("\u0000")) {
            throw Py.TypeError("__name__ must not contain null bytes");
        }
        this.__name__ = name;
    }

    static {
        PyType.addBuilder(PyClass.class, new PyClass$PyExposer());
        TYPE = PyType.fromClass(PyClass.class);
    }
}

