/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.datacollection.TableCondition;

public class TableThreshold {
    private static final String[] OPERATIONS = new String[]{"<", "<=", "==", ">=", ">", "!=", "like", "!like"};
    private long id;
    private int activationEvent;
    private int deactivationEvent;
    private List<List<TableCondition>> conditions;
    private long nextVarId;

    public TableThreshold() {
        this.id = 0L;
        this.activationEvent = 0;
        this.deactivationEvent = 0;
        this.conditions = new ArrayList<List<TableCondition>>(0);
    }

    public TableThreshold(TableThreshold src) {
        this.id = src.id;
        this.activationEvent = src.activationEvent;
        this.deactivationEvent = src.deactivationEvent;
        this.conditions = new ArrayList<List<TableCondition>>(src.conditions.size());
        for (List<TableCondition> sl : src.conditions) {
            ArrayList<TableCondition> dl = new ArrayList<TableCondition>(sl.size());
            for (TableCondition c : sl) {
                dl.add(new TableCondition(c));
            }
            this.conditions.add(dl);
        }
    }

    protected TableThreshold(NXCPMessage msg, long baseId) {
        long varId = baseId;
        this.id = msg.getFieldAsInt64(varId++);
        this.activationEvent = msg.getFieldAsInt32(varId++);
        this.deactivationEvent = msg.getFieldAsInt32(varId++);
        int groupCount = msg.getFieldAsInt32(varId++);
        this.conditions = new ArrayList<List<TableCondition>>(groupCount);
        for (int i = 0; i < groupCount; ++i) {
            int condCount = msg.getFieldAsInt32(varId++);
            ArrayList<TableCondition> list = new ArrayList<TableCondition>(condCount);
            for (int j = 0; j < condCount; ++j) {
                list.add(new TableCondition(msg, varId));
                varId += 3L;
            }
            this.conditions.add(list);
        }
        this.nextVarId = varId;
    }

    protected long fillMessage(NXCPMessage msg, long baseId) {
        long varId = baseId;
        msg.setFieldInt32(varId++, (int)this.id);
        msg.setFieldInt32(varId++, this.activationEvent);
        msg.setFieldInt32(varId++, this.deactivationEvent);
        msg.setFieldInt32(varId++, this.conditions.size());
        for (List<TableCondition> l : this.conditions) {
            msg.setFieldInt32(varId++, l.size());
            for (TableCondition c : l) {
                msg.setField(varId++, c.getColumn());
                msg.setFieldInt16(varId++, c.getOperation());
                msg.setField(varId++, c.getValue());
            }
        }
        return varId;
    }

    public String getConditionAsText() {
        StringBuilder sb = new StringBuilder();
        for (List<TableCondition> group : this.conditions) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            if (this.conditions.size() > 1) {
                sb.append('(');
            }
            for (TableCondition cond : group) {
                if (cond != group.get(0)) {
                    sb.append(" AND ");
                }
                sb.append(cond.getColumn());
                sb.append(' ');
                try {
                    sb.append(OPERATIONS[cond.getOperation()]);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    sb.append('?');
                }
                sb.append(' ');
                sb.append(cond.getValue());
            }
            if (this.conditions.size() <= 1) continue;
            sb.append(')');
        }
        return sb.toString();
    }

    public long getNextVarId() {
        return this.nextVarId;
    }

    public int getActivationEvent() {
        return this.activationEvent;
    }

    public void setActivationEvent(int activationEvent) {
        this.activationEvent = activationEvent;
    }

    public int getDeactivationEvent() {
        return this.deactivationEvent;
    }

    public void setDeactivationEvent(int deactivationEvent) {
        this.deactivationEvent = deactivationEvent;
    }

    public List<List<TableCondition>> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<List<TableCondition>> conditions) {
        this.conditions = conditions;
    }

    public long getId() {
        return this.id;
    }
}

